/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.statetransfer.StateTransferFunctionalTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TransportFlags;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="statetransfer.StateTransferDistSharedCacheLoaderFunctionalTest")
public class StateTransferDistSharedCacheLoaderFunctionalTest
extends StateTransferFunctionalTest {
    ThreadLocal<Boolean> sharedCacheLoader = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return true;
        }
    };
    int id;
    static final int INSERTION_COUNT = 500;

    @BeforeMethod
    public void beforeEachMethod() {
        this.sharedCacheLoader.set(true);
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        super.createCacheManagers();
        this.configurationBuilder.clustering().cacheMode(CacheMode.DIST_SYNC);
    }

    @Override
    protected EmbeddedCacheManager createCacheManager(String cacheName) {
        this.configurationBuilder.persistence().clearStores();
        DummyInMemoryStoreConfigurationBuilder dimcs = new DummyInMemoryStoreConfigurationBuilder(this.configurationBuilder.persistence());
        if (this.sharedCacheLoader.get().booleanValue()) {
            dimcs.storeName(this.getClass().getName());
        } else {
            dimcs.storeName(this.getClass().getName() + this.id++);
        }
        ((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)dimcs.fetchPersistentState(false)).purgeOnStartup(false)).shared(this.sharedCacheLoader.get())).preload(true);
        this.configurationBuilder.persistence().passivation(false).addStore((StoreConfigurationBuilder)dimcs);
        this.configurationBuilder.memory().size(5000L);
        EmbeddedCacheManager cm = this.addClusterEnabledCacheManager(this.sci, this.configurationBuilder, new TransportFlags().withMerge(true));
        cm.defineConfiguration(cacheName, this.configurationBuilder.build());
        return cm;
    }

    public void testUnsharedNotFetchedStoreEntriesRemovedProperly() throws Exception {
        this.sharedCacheLoader.set(false);
        EmbeddedCacheManager cm1 = this.createCacheManager(this.cacheName);
        Cache cache1 = cm1.getCache(this.cacheName);
        this.writeLargeInitialData((Cache<Object, Object>)cache1);
        AssertJUnit.assertEquals((int)500, (int)cache1.getAdvancedCache().getDataContainer().size());
        this.verifyInitialDataOnLoader((Cache<Object, Object>)cache1);
        EmbeddedCacheManager cm2 = this.createCacheManager(this.cacheName);
        Cache cache2 = cm2.getCache(this.cacheName);
        TestingUtil.waitForNoRebalance(cache1, cache2);
        AssertJUnit.assertEquals((int)500, (int)this.getDataContainerSize(cache1));
        AssertJUnit.assertEquals((int)500, (int)this.getDataContainerSize(cache2));
        this.verifyCacheLoaderCount(500, cache2);
        EmbeddedCacheManager cm3 = this.createCacheManager(this.cacheName);
        Cache cache3 = cm3.getCache(this.cacheName);
        TestingUtil.waitForNoRebalance(cache1, cache2, cache3);
        this.eventuallyEquals(1000, () -> this.getDataContainerSize(cache1, cache2, cache3));
    }

    public void testUnsharedFetchedStoreEntriesRemovedProperly() throws Exception {
        this.sharedCacheLoader.set(false);
        EmbeddedCacheManager cm1 = this.createCacheManager(this.cacheName);
        Cache cache1 = cm1.getCache(this.cacheName);
        this.writeLargeInitialData((Cache<Object, Object>)cache1);
        AssertJUnit.assertEquals((int)500, (int)cache1.getAdvancedCache().getDataContainer().size());
        this.verifyInitialDataOnLoader((Cache<Object, Object>)cache1);
        EmbeddedCacheManager cm2 = this.createCacheManager(this.cacheName);
        Cache cache2 = cm2.getCache(this.cacheName);
        TestingUtil.waitForNoRebalance(cache1, cache2);
        AssertJUnit.assertEquals((int)500, (int)cache1.getAdvancedCache().getDataContainer().size());
        AssertJUnit.assertEquals((int)500, (int)cache2.getAdvancedCache().getDataContainer().size());
        this.verifyCacheLoaderCount(500, cache2);
        EmbeddedCacheManager cm3 = this.createCacheManager(this.cacheName);
        Cache cache3 = cm3.getCache(this.cacheName);
        TestingUtil.waitForNoRebalance(cache1, cache2, cache3);
        this.eventuallyEquals(1000, () -> this.getDataContainerSize(cache1, cache2, cache3));
    }

    public void testSharedNotFetchedStoreEntriesRemovedProperly() throws Exception {
        EmbeddedCacheManager cm1 = this.createCacheManager(this.cacheName);
        Cache cache1 = cm1.getCache(this.cacheName);
        this.writeLargeInitialData((Cache<Object, Object>)cache1);
        AssertJUnit.assertEquals((int)500, (int)cache1.getAdvancedCache().getDataContainer().size());
        this.verifyInitialDataOnLoader((Cache<Object, Object>)cache1);
        EmbeddedCacheManager cm2 = this.createCacheManager(this.cacheName);
        Cache cache2 = cm2.getCache(this.cacheName);
        TestingUtil.waitForNoRebalance(cache1, cache2);
        AssertJUnit.assertEquals((int)500, (int)cache1.getAdvancedCache().getDataContainer().size());
        AssertJUnit.assertEquals((int)500, (int)cache2.getAdvancedCache().getDataContainer().size());
        this.verifyCacheLoaderCount(500, cache2);
        EmbeddedCacheManager cm3 = this.createCacheManager(this.cacheName);
        Cache cache3 = cm3.getCache(this.cacheName);
        TestingUtil.waitForNoRebalance(cache1, cache2, cache3);
        this.verifyInitialDataOnLoader((Cache<Object, Object>)cache3);
        this.eventuallyEquals(1000, () -> this.getDataContainerSize(cache1, cache2, cache3));
    }

    protected int getDataContainerSize(Cache<?, ?> ... caches) {
        int count = 0;
        for (Cache<?, ?> c : caches) {
            count += c.getAdvancedCache().getDataContainer().size();
        }
        return count;
    }

    protected void writeLargeInitialData(Cache<Object, Object> c) {
        for (int i = 0; i < 500; ++i) {
            c.put((Object)("key " + i), (Object)("value " + i));
        }
    }

    private void verifyCacheLoaderCount(int expectedCount, Cache ... caches) {
        int count = 0;
        for (Cache cache : caches) {
            count = (int)((long)count + ((DummyInMemoryStore)TestingUtil.getFirstStore(cache)).size());
        }
        AssertJUnit.assertEquals((int)expectedCount, (int)count);
    }

    protected void verifyInitialDataOnLoader(Cache<Object, Object> c) {
        int i;
        DummyInMemoryStore l = (DummyInMemoryStore)TestingUtil.getFirstStore(c);
        for (i = 0; i < 500; ++i) {
            AssertJUnit.assertTrue((String)("Didn't contain key " + i), (boolean)l.contains("key " + i));
        }
        for (i = 0; i < 500; ++i) {
            AssertJUnit.assertEquals((Object)("value " + i), (Object)l.loadEntry("key " + i).getValue());
        }
    }
}

