/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.util.IntSet;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.MagicKey;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.StateProvider;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestException;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CheckPoint;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.impl.TransactionTable;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="lock.StaleTxWithCommitDuringStateTransferTest", groups={"functional"})
@CleanupAfterMethod
public class StaleTxWithCommitDuringStateTransferTest
extends MultipleCacheManagersTest {
    public static final String CACHE_NAME = "testCache";

    @Override
    protected void createCacheManagers() throws Throwable {
        this.createCluster(TestDataSCI.INSTANCE, new ConfigurationBuilder(), 2);
        this.waitForClusterToForm();
    }

    public void testCommit() throws Throwable {
        this.doTest(true);
    }

    public void testRollback() throws Throwable {
        this.doTest(false);
    }

    private void doTest(boolean commit) throws Throwable {
        ConfigurationBuilder cfg = TestCacheManagerFactory.getDefaultCacheConfiguration(true);
        cfg.clustering().cacheMode(CacheMode.DIST_SYNC).stateTransfer().awaitInitialTransfer(false).transaction().lockingMode(LockingMode.PESSIMISTIC);
        this.manager(0).defineConfiguration(CACHE_NAME, cfg.build());
        this.manager(1).defineConfiguration(CACHE_NAME, cfg.build());
        CheckPoint checkpoint = new CheckPoint();
        AdvancedCache cache0 = this.advancedCache(0, CACHE_NAME);
        TransactionManager tm0 = cache0.getTransactionManager();
        StateProvider stateProvider = TestingUtil.extractComponent(cache0, StateProvider.class);
        StateProvider spyProvider = (StateProvider)Mockito.spy((Object)stateProvider);
        ((StateProvider)Mockito.doAnswer(invocation -> {
            Object[] arguments = invocation.getArguments();
            Address source = (Address)arguments[0];
            int topologyId = (Integer)arguments[1];
            CompletionStage result = (CompletionStage)invocation.callRealMethod();
            return result.thenApply(transactions -> {
                try {
                    checkpoint.trigger("post_get_transactions_" + topologyId + "_from_" + String.valueOf(source));
                    checkpoint.awaitStrict("resume_get_transactions_" + topologyId + "_from_" + String.valueOf(source), 10L, TimeUnit.SECONDS);
                    return transactions;
                }
                catch (InterruptedException | TimeoutException e) {
                    throw new TestException(e);
                }
            });
        }).when((Object)spyProvider)).getTransactionsForSegments((Address)ArgumentMatchers.any(Address.class), ArgumentMatchers.anyInt(), (IntSet)ArgumentMatchers.any());
        TestingUtil.replaceComponent(cache0, StateProvider.class, spyProvider, true);
        MagicKey key = new MagicKey("testkey", (Cache<?, ?>)cache0);
        tm0.begin();
        cache0.put((Object)key, (Object)"v0");
        Transaction tx = tm0.suspend();
        DistributionManager dm0 = cache0.getDistributionManager();
        int initialTopologyId = dm0.getCacheTopology().getTopologyId();
        int rebalanceTopologyId = initialTopologyId + 1;
        AdvancedCache cache1 = this.advancedCache(1, CACHE_NAME);
        checkpoint.awaitStrict("post_get_transactions_" + rebalanceTopologyId + "_from_" + String.valueOf(this.address(1)), 10L, TimeUnit.SECONDS);
        Future<Object> future = this.fork(() -> {
            tm0.resume(tx);
            if (commit) {
                tm0.commit();
            } else {
                tm0.rollback();
            }
            return null;
        });
        try {
            future.get(1L, TimeUnit.SECONDS);
            AssertJUnit.fail((String)"Commit/Rollback command should have been blocked");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        checkpoint.trigger("resume_get_transactions_" + rebalanceTopologyId + "_from_" + String.valueOf(this.address(1)));
        TestingUtil.waitForNoRebalance(this.caches(CACHE_NAME));
        future.get(10L, TimeUnit.SECONDS);
        if (commit) {
            AssertJUnit.assertEquals((Object)"v0", (Object)TestingUtil.extractComponent(cache0, InternalDataContainer.class).get((Object)key).getValue());
            AssertJUnit.assertEquals((Object)"v0", (Object)TestingUtil.extractComponent(cache1, InternalDataContainer.class).get((Object)key).getValue());
        } else {
            AssertJUnit.assertNull((Object)TestingUtil.extractComponent(cache0, InternalDataContainer.class).get((Object)key));
            AssertJUnit.assertNull((Object)TestingUtil.extractComponent(cache1, InternalDataContainer.class).get((Object)key));
        }
        TransactionTable tt0 = TestingUtil.extractComponent(cache0, TransactionTable.class);
        TransactionTable tt1 = TestingUtil.extractComponent(cache1, TransactionTable.class);
        StaleTxWithCommitDuringStateTransferTest.eventually(() -> tt0.getLocalTxCount() == 0 && tt1.getRemoteTxCount() == 0);
    }
}

