/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import jakarta.transaction.RollbackException;
import java.util.Arrays;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.tx.VersionedCommitCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.statetransfer.StateTransferInterceptor;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.concurrent.StateSequencer;
import org.infinispan.test.concurrent.StateSequencerUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.ControlledConsistentHashFactory;
import org.infinispan.util.concurrent.locks.LockManager;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="statetransfer.CommitTimeoutTest")
@CleanupAfterMethod
public class CommitTimeoutTest
extends MultipleCacheManagersTest {
    private static final String TEST_KEY = "key";
    private static final String TX1_VALUE = "value1";
    private static final String TX2_VALUE = "value2";

    @Override
    protected void createCacheManagers() throws Throwable {
        ControlledConsistentHashFactory.Default consistentHashFactory = new ControlledConsistentHashFactory.Default(1, 2);
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.DIST_SYNC);
        builder.clustering().remoteTimeout(2000L);
        builder.clustering().hash().numSegments(1).consistentHashFactory((ConsistentHashFactory)consistentHashFactory);
        builder.transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        this.addClusterEnabledCacheManager(builder);
        this.addClusterEnabledCacheManager(builder);
        this.addClusterEnabledCacheManager(builder);
        this.waitForClusterToForm();
    }

    public void testCommitDoesntWriteAfterRollback() throws Exception {
        StateSequencer sequencer = new StateSequencer();
        sequencer.logicalThread("tx1", "tx1:begin", "tx1:block_commit_on_backup", "tx1:after_rollback_on_primary", "tx1:after_rollback_on_backup", "tx1:resume_commit_on_backup", "tx1:after_commit_on_backup", "tx1:check");
        sequencer.logicalThread("tx2", "tx2:begin", "tx2:end");
        sequencer.order("tx1:after_rollback_on_backup", "tx2:begin", "tx2:end", "tx1:resume_commit_on_backup");
        StateSequencerUtil.advanceOnInterceptor(sequencer, this.cache(2), StateTransferInterceptor.class, StateSequencerUtil.matchCommand(VersionedCommitCommand.class).matchCount(0).build()).before("tx1:block_commit_on_backup", "tx1:resume_commit_on_backup").after("tx1:after_commit_on_backup", new String[0]);
        StateSequencerUtil.advanceOnInterceptor(sequencer, this.cache(1), StateTransferInterceptor.class, StateSequencerUtil.matchCommand(RollbackCommand.class).build()).after("tx1:after_rollback_on_primary", new String[0]);
        StateSequencerUtil.advanceOnInterceptor(sequencer, this.cache(2), StateTransferInterceptor.class, StateSequencerUtil.matchCommand(RollbackCommand.class).build()).after("tx1:after_rollback_on_backup", new String[0]);
        AssertJUnit.assertEquals(Arrays.asList(this.address(1), this.address(2)), (Object)this.cacheTopology(0).getDistribution((Object)TEST_KEY).writeOwners());
        sequencer.advance("tx1:begin");
        this.tm(0).begin();
        this.cache(0).put((Object)TEST_KEY, (Object)TX1_VALUE);
        try {
            this.tm(0).commit();
        }
        catch (RollbackException e) {
            log.debugf("Commit timed out as expected", (Object)e);
        }
        sequencer.advance("tx2:begin");
        LockManager lockManager1 = TestingUtil.extractLockManager(this.cache(1));
        AssertJUnit.assertFalse((boolean)lockManager1.isLocked((Object)TEST_KEY));
        this.tm(0).begin();
        this.cache(0).put((Object)TEST_KEY, (Object)TX2_VALUE);
        this.tm(0).commit();
        this.checkValue();
        sequencer.advance("tx2:end");
        sequencer.advance("tx1:check");
        this.checkValue();
    }

    private void checkValue() {
        for (Cache cache : this.caches()) {
            AssertJUnit.assertEquals((Object)TX2_VALUE, (Object)cache.get((Object)TEST_KEY));
        }
    }

    @Test(enabled=false, description="Fix for this scenario is not implemented yet - rollback is asynchronous")
    public void testCommitDoesntWriteAfterTxEnd() throws Exception {
        StateSequencer sequencer = new StateSequencer();
        sequencer.logicalThread("tx1", "tx1:begin", "tx1:block_commit_on_backup", "tx1:after_rollback_on_primary", "tx1:block_rollback_on_backup", "tx1:resume_commit_on_backup", "tx1:after_commit_on_backup", "tx1:resume_rollback_on_backup", "tx1:after_rollback_on_backup", "tx1:check");
        StateSequencerUtil.advanceOnInterceptor(sequencer, this.cache(2), StateTransferInterceptor.class, StateSequencerUtil.matchCommand(CommitCommand.class).matchCount(0).build()).before("tx1:block_commit_on_backup", "tx1:resume_commit_on_backup").after("tx1:after_commit_on_backup", new String[0]);
        StateSequencerUtil.advanceOnInterceptor(sequencer, this.cache(1), StateTransferInterceptor.class, StateSequencerUtil.matchCommand(RollbackCommand.class).build()).after("tx1:after_rollback_on_primary", new String[0]);
        StateSequencerUtil.advanceOnInterceptor(sequencer, this.cache(2), StateTransferInterceptor.class, StateSequencerUtil.matchCommand(RollbackCommand.class).build()).before("tx1:block_rollback_on_backup", new String[0]).after("tx1:after_rollback_on_backup", new String[0]);
        AssertJUnit.assertEquals(Arrays.asList(this.address(1), this.address(2)), (Object)this.cacheTopology(0).getDistribution((Object)TEST_KEY).writeOwners());
        Future<Object> lockCheckFuture = this.fork(() -> {
            sequencer.enter("tx1:resume_rollback_on_backup");
            try {
                AssertJUnit.assertTrue((boolean)TestingUtil.extractLockManager(this.cache(1)).isLocked((Object)TEST_KEY));
            }
            finally {
                sequencer.exit("tx1:resume_rollback_on_backup");
            }
            return null;
        });
        sequencer.advance("tx1:begin");
        this.tm(0).begin();
        this.cache(0).put((Object)TEST_KEY, (Object)TX1_VALUE);
        this.tm(0).commit();
        sequencer.advance("tx1:check");
        AssertJUnit.assertFalse((boolean)TestingUtil.extractLockManager(this.cache(1)).isLocked((Object)TEST_KEY));
        lockCheckFuture.get(10L, TimeUnit.SECONDS);
    }
}

