/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.security;

import javax.security.auth.Subject;
import org.infinispan.configuration.cache.AuthorizationConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalAuthorizationConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.Security;
import org.infinispan.security.mappers.IdentityRoleMapper;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="security.SecureListenerTest")
public class SecureListenerTest
extends SingleCacheManagerTest {
    static final Subject ADMIN = TestingUtil.makeSubject("admin");
    static final Subject SUBJECT_A = TestingUtil.makeSubject("A", "listener");
    static final Subject SUBJECT_B = TestingUtil.makeSubject("B", "listener");

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        GlobalConfigurationBuilder global = new GlobalConfigurationBuilder();
        GlobalAuthorizationConfigurationBuilder globalRoles = global.security().authorization().enable().groupOnlyMapping(false).principalRoleMapper((PrincipalRoleMapper)new IdentityRoleMapper());
        ConfigurationBuilder config = TestCacheManagerFactory.getDefaultCacheConfiguration(true);
        AuthorizationConfigurationBuilder authConfig = config.security().authorization().enable();
        globalRoles.role("listener").permission(AuthorizationPermission.LISTEN).role("admin").permission(AuthorizationPermission.ALL);
        authConfig.role("listener").role("admin");
        return TestCacheManagerFactory.createCacheManager(global, config);
    }

    @Override
    protected void setup() throws Exception {
        Security.doAs((Subject)ADMIN, () -> {
            try {
                this.cacheManager = this.createCacheManager();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (this.cache == null) {
                this.cache = this.cacheManager.getCache();
            }
        });
    }

    public void testSecureListenerSubject() {
        this.registerListener(SUBJECT_A);
        this.registerListener(SUBJECT_B);
        Security.doAs((Subject)ADMIN, () -> this.cacheManager.getCache().put((Object)"key", (Object)"value"));
    }

    private void registerListener(Subject subject) {
        Security.doAs((Subject)subject, () -> this.cacheManager.getCache().addListener((Object)new SubjectVerifyingListener(subject)));
    }

    @Override
    protected void teardown() {
        Security.doAs((Subject)ADMIN, () -> SecureListenerTest.super.teardown());
    }

    @Override
    protected void clearContent() {
        Security.doAs((Subject)ADMIN, () -> this.cacheManager.getCache().clear());
    }

    @Listener
    public static final class SubjectVerifyingListener {
        final Subject subject;

        public SubjectVerifyingListener(Subject subject) {
            this.subject = subject;
        }

        @CacheEntryCreated
        public void handleCreated(CacheEntryCreatedEvent<String, String> event) {
            AssertJUnit.assertEquals((Object)this.subject, (Object)Security.getSubject());
        }
    }
}

