/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.security;

import java.util.Set;
import javax.security.auth.Subject;
import org.infinispan.configuration.cache.AuthorizationConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalAuthorizationConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.AuthorizationManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.Security;
import org.infinispan.security.mappers.IdentityRoleMapper;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="security.RolePermissionTest")
public class RolePermissionTest
extends SingleCacheManagerTest {
    static final Subject ADMIN = TestingUtil.makeSubject("admin");
    static final Subject SUBJECT_A = TestingUtil.makeSubject("A", "role1");
    static final Subject SUBJECT_WITHOUT_PRINCIPAL = TestingUtil.makeSubject(new String[0]);
    AuthorizationManager authzManager;

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        GlobalConfigurationBuilder global = new GlobalConfigurationBuilder();
        GlobalAuthorizationConfigurationBuilder globalRoles = global.security().authorization().enable().groupOnlyMapping(false).principalRoleMapper((PrincipalRoleMapper)new IdentityRoleMapper());
        ConfigurationBuilder config = TestCacheManagerFactory.getDefaultCacheConfiguration(true);
        globalRoles.role("role1").permission(AuthorizationPermission.EXEC).role("role2").permission(AuthorizationPermission.EXEC).role("role3").permission(new AuthorizationPermission[]{AuthorizationPermission.READ, AuthorizationPermission.WRITE}).role("role4").permission(new AuthorizationPermission[]{AuthorizationPermission.READ, AuthorizationPermission.WRITE}).role("role5").permission(new AuthorizationPermission[]{AuthorizationPermission.READ, AuthorizationPermission.WRITE}).role("admin").permission(AuthorizationPermission.ALL);
        AuthorizationConfigurationBuilder authConfig = config.security().authorization().enable();
        authConfig.role("role1").role("role2").role("admin");
        return TestCacheManagerFactory.createCacheManager(global, config);
    }

    @Override
    protected void setup() throws Exception {
        this.authzManager = (AuthorizationManager)Security.doAs((Subject)ADMIN, () -> {
            try {
                this.cacheManager = this.createCacheManager();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (this.cache == null) {
                this.cache = this.cacheManager.getCache();
            }
            return this.cache.getAdvancedCache().getAuthorizationManager();
        });
    }

    public void testPermissionAndRole() {
        Security.doAs((Subject)SUBJECT_A, () -> {
            this.authzManager.checkPermission(AuthorizationPermission.EXEC, "role1");
            return null;
        });
    }

    public void testPermissionAndNoRole() {
        Security.doAs((Subject)SUBJECT_A, () -> {
            this.authzManager.checkPermission(AuthorizationPermission.EXEC);
            return null;
        });
    }

    @Test(expectedExceptions={SecurityException.class})
    public void testWrongPermissionAndNoRole() {
        Security.doAs((Subject)SUBJECT_A, () -> {
            this.authzManager.checkPermission(AuthorizationPermission.LISTEN);
            return null;
        });
    }

    @Test(expectedExceptions={SecurityException.class})
    public void testWrongPermissionAndRole() {
        Security.doAs((Subject)SUBJECT_A, () -> {
            this.authzManager.checkPermission(AuthorizationPermission.LISTEN, "role1");
            return null;
        });
    }

    @Test(expectedExceptions={SecurityException.class})
    public void testPermissionAndWrongRole() {
        Security.doAs((Subject)SUBJECT_A, () -> {
            this.authzManager.checkPermission(AuthorizationPermission.EXEC, "role2");
            return null;
        });
    }

    @Test(expectedExceptions={SecurityException.class})
    public void testWrongPermissionAndWrongRole() {
        Security.doAs((Subject)SUBJECT_A, () -> {
            this.authzManager.checkPermission(AuthorizationPermission.LISTEN, "role2");
            return null;
        });
    }

    public void testNoPrincipalInSubject() {
        Security.doAs((Subject)SUBJECT_WITHOUT_PRINCIPAL, () -> {
            this.authzManager.checkPermission(AuthorizationPermission.NONE);
            return null;
        });
    }

    public void testAccessibleCaches() {
        Security.doAs((Subject)ADMIN, () -> {
            for (int i = 3; i < 6; ++i) {
                ConfigurationBuilder config = TestCacheManagerFactory.getDefaultCacheConfiguration(true);
                config.security().authorization().enable().role("role" + i).role("admin");
                this.cacheManager.createCache("cache" + i, config.build());
            }
        });
        Set names = (Set)Security.doAs((Subject)TestingUtil.makeSubject("Subject34", "role3", "role4"), () -> this.cacheManager.getAccessibleCacheNames());
        AssertJUnit.assertEquals((int)2, (int)names.size());
        AssertJUnit.assertTrue((String)names.toString(), (boolean)names.contains("cache3"));
        AssertJUnit.assertTrue((String)names.toString(), (boolean)names.contains("cache4"));
        names = (Set)Security.doAs((Subject)TestingUtil.makeSubject("Subject35", "role3", "role5"), () -> this.cacheManager.getAccessibleCacheNames());
        AssertJUnit.assertEquals((int)2, (int)names.size());
        AssertJUnit.assertTrue((String)names.toString(), (boolean)names.contains("cache3"));
        AssertJUnit.assertTrue((String)names.toString(), (boolean)names.contains("cache5"));
        names = (Set)Security.doAs((Subject)TestingUtil.makeSubject("Subject45", "role4", "role5"), () -> this.cacheManager.getAccessibleCacheNames());
        AssertJUnit.assertEquals((int)2, (int)names.size());
        AssertJUnit.assertTrue((String)names.toString(), (boolean)names.contains("cache4"));
        AssertJUnit.assertTrue((String)names.toString(), (boolean)names.contains("cache5"));
        names = (Set)Security.doAs((Subject)TestingUtil.makeSubject("Subject0"), () -> this.cacheManager.getAccessibleCacheNames());
        AssertJUnit.assertEquals((int)0, (int)names.size());
    }

    @Override
    protected void teardown() {
        Security.doAs((Subject)ADMIN, () -> {
            RolePermissionTest.super.teardown();
            return null;
        });
    }

    @Override
    protected void clearContent() {
        Security.doAs((Subject)ADMIN, () -> {
            this.cacheManager.getCache().clear();
            return null;
        });
    }
}

