/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.security;

import javax.security.auth.Subject;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.AuthorizationConfigurationBuilder;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalAuthorizationConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.functional.FunctionalTestUtils;
import org.infinispan.globalstate.ConfigurationStorage;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.Role;
import org.infinispan.security.RolePermissionMapper;
import org.infinispan.security.Security;
import org.infinispan.security.mappers.ClusterPermissionMapper;
import org.infinispan.security.mappers.ClusterRoleMapper;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="security.DynamicRBACRestartTest")
public class DynamicRBACRestartTest
extends MultipleCacheManagersTest {
    static final Subject ADMIN = TestingUtil.makeSubject("admin");
    private ClusterRoleMapper crm;
    private ClusterPermissionMapper cpm;

    @Override
    protected void createCacheManagers() throws Throwable {
        Security.doAs((Subject)ADMIN, () -> {
            this.addClusterEnabledCacheManager(this.getGlobalConfigurationBuilder("A", true), this.getConfigurationBuilder());
            this.addClusterEnabledCacheManager(this.getGlobalConfigurationBuilder("B", true), this.getConfigurationBuilder());
            this.waitForClusterToForm();
            this.crm = (ClusterRoleMapper)((EmbeddedCacheManager)this.cacheManagers.get(0)).getCacheManagerConfiguration().security().authorization().principalRoleMapper();
            this.crm.grant("admin", "admin");
            this.cpm = (ClusterPermissionMapper)((EmbeddedCacheManager)this.cacheManagers.get(0)).getCacheManagerConfiguration().security().authorization().rolePermissionMapper();
            FunctionalTestUtils.await(this.cpm.addRole(Role.newRole((String)"wizard", (String)"wizard role", (boolean)false, (boolean)true, (AuthorizationPermission[])new AuthorizationPermission[]{AuthorizationPermission.ALL_WRITE})));
            FunctionalTestUtils.await(this.cpm.addRole(Role.newRole((String)"cleric", null, (boolean)false, (boolean)true, (AuthorizationPermission[])new AuthorizationPermission[]{AuthorizationPermission.ALL_READ})));
            return null;
        });
    }

    private ConfigurationBuilder getConfigurationBuilder() {
        ConfigurationBuilder config = TestCacheManagerFactory.getDefaultCacheConfiguration(true);
        config.clustering().cacheMode(CacheMode.DIST_SYNC);
        AuthorizationConfigurationBuilder authConfig = config.security().authorization().enable();
        authConfig.role("reader").role("writer").role("admin");
        return config;
    }

    private GlobalConfigurationBuilder getGlobalConfigurationBuilder(String id, boolean clear) {
        String stateDirectory = CommonsTestingUtil.tmpDirectory((String[])new String[]{this.getClass().getSimpleName(), id});
        if (clear) {
            Util.recursiveFileRemove((String)stateDirectory);
        }
        GlobalConfigurationBuilder global = GlobalConfigurationBuilder.defaultClusteredBuilder();
        global.globalState().enable().persistentLocation(stateDirectory).configurationStorage(ConfigurationStorage.OVERLAY);
        GlobalAuthorizationConfigurationBuilder globalRoles = global.security().authorization().enable().groupOnlyMapping(false).principalRoleMapper((PrincipalRoleMapper)new ClusterRoleMapper()).rolePermissionMapper((RolePermissionMapper)new ClusterPermissionMapper());
        globalRoles.role("reader").permission(AuthorizationPermission.ALL_READ).role("writer").permission(AuthorizationPermission.ALL_WRITE).role("admin").permission(AuthorizationPermission.ALL);
        return global;
    }

    public void testPermissionsRestart() {
        ConfigurationBuilder config = TestCacheManagerFactory.getDefaultCacheConfiguration(true);
        config.clustering().cacheMode(CacheMode.DIST_SYNC);
        AuthorizationConfigurationBuilder authConfig = config.security().authorization().enable();
        authConfig.role("admin").role("wizard").role("cleric");
        Security.doAs((Subject)ADMIN, () -> ((EmbeddedCacheManager)this.cacheManagers.get(0)).administration().createCache("minastirith", config.build()));
        Security.doAs((Subject)ADMIN, () -> TestingUtil.killCacheManagers(this.cacheManagers));
        this.cacheManagers.clear();
        Security.doAs((Subject)ADMIN, () -> {
            this.addClusterEnabledCacheManager(this.getGlobalConfigurationBuilder("A", false), this.getConfigurationBuilder());
            this.addClusterEnabledCacheManager(this.getGlobalConfigurationBuilder("B", false), this.getConfigurationBuilder());
            this.waitForClusterToForm();
        });
        AdvancedCache cache = this.manager(0).getCache("minastirith").getAdvancedCache();
        cache.withSubject(TestingUtil.makeSubject("wizard")).put((Object)"k1", (Object)"v1");
        AssertJUnit.assertEquals((Object)"v1", (Object)cache.withSubject(TestingUtil.makeSubject("cleric")).get((Object)"k1"));
    }

    @Override
    @AfterClass(alwaysRun=true)
    protected void destroy() {
        Security.doAs((Subject)ADMIN, () -> {
            DynamicRBACRestartTest.super.destroy();
            return null;
        });
    }

    @Override
    protected void clearContent() {
        Security.doAs((Subject)ADMIN, () -> {
            this.cacheManagers.forEach(cm -> cm.getCache().clear());
            return null;
        });
    }
}

