/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.infinispan.Cache;
import org.infinispan.cache.impl.EncoderCache;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.MagicKey;
import org.infinispan.expiration.impl.TouchCommand;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.test.Mocks;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCIImpl;
import org.infinispan.test.fwk.CheckPoint;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="remoting.RemoteShutdownDuringOperationTest")
public class RemoteShutdownDuringOperationTest
extends MultipleCacheManagersTest {
    private static final String CACHE_NAME = "distSync";
    private TolerateSuspectOperation operation;

    protected RemoteShutdownDuringOperationTest withOperation(TolerateSuspectOperation operation) {
        this.operation = operation;
        return this;
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cb = RemoteShutdownDuringOperationTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
        int numOwners = 2;
        if (this.operation == TolerateSuspectOperation.GET) {
            numOwners = 1;
        }
        cb.clustering().hash().numOwners(numOwners);
        this.createClusteredCaches(2, CACHE_NAME, TestDataSCIImpl.INSTANCE, cb);
    }

    @Test
    public void testShutdownDuringOperation() throws Exception {
        EncoderCache<MagicKey, String> c0 = this.cache(0);
        EncoderCache<MagicKey, String> c1 = this.cache(1);
        Assertions.assertThat((boolean)ComponentRegistry.of(c1).getStatus().isTerminated()).isFalse();
        MagicKey key = new MagicKey("remote-key", (Cache<?, ?>)c1);
        Assertions.assertThat((String)((String)c1.put((Object)key, (Object)"value"))).isNull();
        Assertions.assertThat((String)((String)c0.get((Object)key))).isEqualTo("value");
        CheckPoint checkPoint = new CheckPoint();
        checkPoint.triggerForever("after_release");
        Mocks.blockInboundCacheRpcCommand(c1, checkPoint, this.operation.verify());
        SoftAssertions softly = new SoftAssertions();
        CompletableFuture<Void> cs = this.operation.operate(c0, key, softly).toCompletableFuture();
        checkPoint.awaitStrict("before_invocation", 10L, TimeUnit.SECONDS);
        c1.stop();
        Assertions.assertThat((boolean)ComponentRegistry.of(c1).getStatus().isTerminated()).isTrue();
        checkPoint.trigger("before_release", 1);
        cs.get(10L, TimeUnit.SECONDS);
        softly.assertAll();
    }

    protected EncoderCache<MagicKey, String> cache(int index) {
        return (EncoderCache)this.cache(index, CACHE_NAME);
    }

    @Override
    public Object[] factory() {
        return Stream.of(TolerateSuspectOperation.values()).map(op -> new RemoteShutdownDuringOperationTest().withOperation((TolerateSuspectOperation)((Object)op))).toArray();
    }

    @Override
    protected String parameters() {
        return "[operation=" + String.valueOf((Object)this.operation) + "]";
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum TolerateSuspectOperation {
        TOUCH{

            @Override
            public CompletionStage<Void> operate(EncoderCache<MagicKey, String> cache, MagicKey key, SoftAssertions softly) {
                return cache.touch((Object)key, false).handle((touched, t) -> {
                    if (t != null) {
                        softly.fail("Unexpected exception", t);
                    } else {
                        softly.assertThat(touched).isTrue();
                    }
                    return null;
                });
            }

            @Override
            public boolean verifyCommand(CacheRpcCommand cmd) {
                if (cmd instanceof SingleRpcCommand) {
                    return ((SingleRpcCommand)cmd).getCommand() instanceof TouchCommand;
                }
                return false;
            }
        }
        ,
        GET{

            @Override
            public CompletionStage<Void> operate(EncoderCache<MagicKey, String> cache, MagicKey key, SoftAssertions softly) {
                return cache.getAsync((Object)key).handle((value, t) -> {
                    if (t != null) {
                        softly.fail("Unexpected exception", t);
                    } else {
                        softly.assertThat(value).isNull();
                    }
                    return null;
                });
            }

            @Override
            public boolean verifyCommand(CacheRpcCommand cmd) {
                return cmd instanceof ClusteredGetCommand;
            }
        };


        public abstract CompletionStage<Void> operate(EncoderCache<MagicKey, String> var1, MagicKey var2, SoftAssertions var3);

        public abstract boolean verifyCommand(CacheRpcCommand var1);

        public Predicate<? super CacheRpcCommand> verify() {
            return this::verifyCommand;
        }
    }
}

