/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.file;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletionException;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.configuration.cache.AbstractSegmentedStoreConfiguration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.SingleFileStoreConfigurationBuilder;
import org.infinispan.persistence.AbstractPersistenceCompatibilityTest;
import org.infinispan.persistence.IdentityKeyValueWrapper;
import org.infinispan.persistence.file.SingleFileStore;
import org.infinispan.test.data.Value;
import org.testng.AssertJUnit;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.file.SingleFileStoreCompatibilityTest")
public class SingleFileStoreCompatibilityTest
extends AbstractPersistenceCompatibilityTest<Value> {
    private static final Map<AbstractPersistenceCompatibilityTest.Version, String> files = new HashMap<AbstractPersistenceCompatibilityTest.Version, String>();
    private static final Map<AbstractPersistenceCompatibilityTest.Version, byte[]> magic;

    public SingleFileStoreCompatibilityTest() {
        super(IdentityKeyValueWrapper.instance());
    }

    @DataProvider
    public Object[][] segmented() {
        return new Object[][]{{false, false}, {false, true}, {true, false}, {true, true}};
    }

    @Test(dataProvider="segmented")
    public void testReadWriteFrom101(boolean oldSegmented, boolean newSegmented) throws Exception {
        this.setParameters(AbstractPersistenceCompatibilityTest.Version._10_1, oldSegmented, newSegmented);
        this.beforeStartCache();
        this.cacheManager.defineConfiguration(this.cacheName(), this.cacheConfiguration(false).build());
        Exceptions.expectException(CacheConfigurationException.class, CompletionException.class, (String)".*ISPN000616.*", () -> this.cacheManager.getCache(this.cacheName()));
    }

    @Test(dataProvider="segmented")
    public void testReadWriteFrom11(boolean oldSegmented, boolean newSegmented) throws Exception {
        this.setParameters(AbstractPersistenceCompatibilityTest.Version._11_0, oldSegmented, newSegmented);
        this.doTestReadWrite();
    }

    @Test(dataProvider="segmented")
    public void testReadWriteFrom121(boolean oldSegmented, boolean newSegmented) throws Exception {
        this.setParameters(AbstractPersistenceCompatibilityTest.Version._12_1, oldSegmented, newSegmented);
        this.doTestReadWrite();
    }

    @Override
    protected void beforeStartCache() throws Exception {
        InputStream is = FileLookupFactory.newInstance().lookupFile(files.get((Object)this.oldVersion), Thread.currentThread().getContextClassLoader());
        if (this.oldSegmented) {
            File segment1File = this.getSegmentFile(1);
            this.createParentDirectories(segment1File);
            Files.copy(is, segment1File.toPath(), StandardCopyOption.REPLACE_EXISTING);
            File segment2File = this.getSegmentFile(2);
            this.createParentDirectories(segment2File);
            Files.write(segment2File.toPath(), magic.get((Object)this.oldVersion), new OpenOption[0]);
        } else {
            File sfsFile = SingleFileStore.getStoreFile((String)this.tmpDirectory, (String)this.cacheName());
            this.createParentDirectories(sfsFile);
            Files.copy(is, sfsFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private void createParentDirectories(File file) {
        if (!file.getParentFile().exists()) {
            AssertJUnit.assertTrue((boolean)file.getParentFile().mkdirs());
        }
    }

    private File getSegmentFile(int segment) {
        String segmentPath = AbstractSegmentedStoreConfiguration.fileLocationTransform((String)this.tmpDirectory, (int)segment);
        return SingleFileStore.getStoreFile((String)segmentPath, (String)this.cacheName());
    }

    @Override
    protected String cacheName() {
        return "sfs-cache-store";
    }

    @Override
    protected void configurePersistence(ConfigurationBuilder builder, boolean generatingData) {
        ((SingleFileStoreConfigurationBuilder)builder.persistence().addSingleFileStore().segmented(this.oldSegmented)).location(this.tmpDirectory);
    }

    static {
        files.put(AbstractPersistenceCompatibilityTest.Version._10_1, "sfs/10_1/sfs-store-cache.dat");
        files.put(AbstractPersistenceCompatibilityTest.Version._11_0, "sfs/11_0/sfs-store-cache.dat");
        files.put(AbstractPersistenceCompatibilityTest.Version._12_1, "sfs/12_1/sfs-store-cache.dat");
        magic = new HashMap<AbstractPersistenceCompatibilityTest.Version, byte[]>();
        magic.put(AbstractPersistenceCompatibilityTest.Version._10_1, SingleFileStore.MAGIC_BEFORE_11);
        magic.put(AbstractPersistenceCompatibilityTest.Version._11_0, SingleFileStore.MAGIC_11_0);
        magic.put(AbstractPersistenceCompatibilityTest.Version._12_0, SingleFileStore.MAGIC_12_0);
        magic.put(AbstractPersistenceCompatibilityTest.Version._12_1, SingleFileStore.MAGIC_12_1);
    }
}

