/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.file;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.SingleFileStoreConfigurationBuilder;
import org.infinispan.xsite.statetransfer.AbstractStateTransferTest;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="persistence.file.SingleFileGracefulShutdownMigrationXsiteTest")
public class SingleFileGracefulShutdownMigrationXsiteTest
extends AbstractStateTransferTest {
    private String tmpDirectory;
    private String lonDirectory;
    private String nycDirectory;

    public SingleFileGracefulShutdownMigrationXsiteTest() {
        this.initialClusterSize = 1;
        this.nycBackupStrategy = BackupConfiguration.BackupStrategy.ASYNC;
        this.lonBackupStrategy = BackupConfiguration.BackupStrategy.ASYNC;
        this.implicitBackupCache = true;
    }

    @Override
    @BeforeClass(alwaysRun=true)
    public void createBeforeClass() {
        this.tmpDirectory = CommonsTestingUtil.tmpDirectory(this.getClass());
        new File(this.tmpDirectory).mkdirs();
        File f = new File(this.tmpDirectory, "LON-1");
        this.lonDirectory = f.getPath();
        f.mkdirs();
        f = new File(this.tmpDirectory, "NYC-2");
        this.nycDirectory = f.getPath();
        f.mkdirs();
        try (InputStream nyc = FileLookupFactory.newInstance().lookupFile("sfs/corrupt/xsite/nyc.dat", Thread.currentThread().getContextClassLoader());
             InputStream lon = FileLookupFactory.newInstance().lookupFile("sfs/corrupt/xsite/lon.dat", Thread.currentThread().getContextClassLoader());){
            Files.copy(lon, Paths.get(this.lonDirectory, new String[0]).resolve("defaultcache.dat"), StandardCopyOption.REPLACE_EXISTING);
            Files.copy(nyc, Paths.get(this.nycDirectory, new String[0]).resolve("defaultcache.dat"), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        super.createBeforeClass();
    }

    @Override
    @AfterClass(alwaysRun=true)
    protected void clearContent() {
        super.destroy();
        Util.recursiveFileRemove((String)this.tmpDirectory);
    }

    private ConfigurationBuilder cfg(String location) {
        ConfigurationBuilder builder = SingleFileGracefulShutdownMigrationXsiteTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
        ((SingleFileStoreConfigurationBuilder)builder.persistence().addSingleFileStore().segmented(false)).location(location).fetchPersistentState(true);
        return builder;
    }

    @Override
    protected ConfigurationBuilder getNycActiveConfig() {
        return this.cfg(this.nycDirectory);
    }

    @Override
    protected ConfigurationBuilder getLonActiveConfig() {
        return this.cfg(this.lonDirectory);
    }

    @Test
    public void testAllEntriesRecovered() {
        Cache lonCache = this.cache("LON-1", 0);
        Cache nycCache = this.cache("NYC-2", 0);
        this.startStateTransfer(lonCache, "NYC-2");
        this.startStateTransfer(nycCache, "LON-1");
        this.assertEventuallyStateTransferNotRunning();
        this.assertEventuallyStateTransferNotRunning(this.cache("NYC-2", 0));
        this.assertInSite("LON-1", cache -> AssertJUnit.assertEquals((Object)"sfs-value-lon", (Object)cache.get((Object)"LON-1")));
        this.assertInSite("LON-1", cache -> AssertJUnit.assertEquals((Object)"sfs-value-nyc", (Object)cache.get((Object)"NYC-2")));
        this.assertInSite("NYC-2", cache -> AssertJUnit.assertEquals((Object)"sfs-value-lon", (Object)cache.get((Object)"LON-1")));
        this.assertInSite("NYC-2", cache -> AssertJUnit.assertEquals((Object)"sfs-value-nyc", (Object)cache.get((Object)"NYC-2")));
        lonCache.put((Object)"LON-1", (Object)"Updated");
        this.assertEventuallyInSite("LON-1", cache -> Objects.equals("Updated", cache.get((Object)"LON-1")), 30L, TimeUnit.SECONDS);
        this.assertEventuallyInSite("NYC-2", cache -> Objects.equals("Updated", cache.get((Object)"LON-1")), 30L, TimeUnit.SECONDS);
        nycCache.put((Object)"NYC-2", (Object)"Updated");
        this.assertEventuallyInSite("LON-1", cache -> Objects.equals("Updated", cache.get((Object)"NYC-2")), 30L, TimeUnit.SECONDS);
        this.assertEventuallyInSite("NYC-2", cache -> Objects.equals("Updated", cache.get((Object)"NYC-2")), 30L, TimeUnit.SECONDS);
    }
}

