/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.file;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.JavaSerializationMarshaller;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.ByRef;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.SingleFileStoreConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="persistence.file.SingleFileGracefulShutdownMigrationTest")
public class SingleFileGracefulShutdownMigrationTest
extends AbstractInfinispanTest {
    private static final String CACHE_NAME = "update-cache";
    private String tmpDirectory;

    @BeforeClass
    protected void setUpTempDir() throws IOException {
        this.tmpDirectory = CommonsTestingUtil.tmpDirectory(this.getClass());
        new File(this.tmpDirectory).mkdirs();
    }

    @AfterClass
    protected void clearTempDir() {
        Util.recursiveFileRemove((String)this.tmpDirectory);
    }

    @DataProvider(name="testFiles")
    Object[][] singleTypes() {
        return new Object[][]{{"sfs/11_0/all-entries-java-serialization.dat", Marshaller.JAVA_SERIALIZATION}, {"sfs/12_0/all-entries-java-serialization.dat", Marshaller.JAVA_SERIALIZATION}, {"sfs/corrupt/all-entries.dat", Marshaller.PROTOSTREAM}, {"sfs/12_0/all-entries.dat", Marshaller.PROTOSTREAM}};
    }

    @Test(dataProvider="testFiles")
    public void testAllEntriesRecovered(String fileName, Marshaller marshallerType) throws Exception {
        ByRef.Integer i;
        Cache cache;
        int numEntries = 1003;
        InputStream is = FileLookupFactory.newInstance().lookupFile(fileName, Thread.currentThread().getContextClassLoader());
        Files.copy(is, Paths.get(this.tmpDirectory, new String[0]).resolve("update-cache.dat"), StandardCopyOption.REPLACE_EXISTING);
        ConfigurationBuilderHolder cbh = new ConfigurationBuilderHolder();
        if (marshallerType == Marshaller.JAVA_SERIALIZATION) {
            cbh.getGlobalConfigurationBuilder().serialization().marshaller((org.infinispan.commons.marshall.Marshaller)new JavaSerializationMarshaller());
        }
        ((SingleFileStoreConfigurationBuilder)cbh.newConfigurationBuilder(CACHE_NAME).persistence().addSingleFileStore().segmented(false)).location(this.tmpDirectory);
        try (DefaultCacheManager cacheManager = new DefaultCacheManager(cbh, true);){
            cache = cacheManager.getCache(CACHE_NAME);
            i = new ByRef.Integer(0);
            cache.forEach((k, v) -> i.inc());
            AssertJUnit.assertEquals((int)numEntries, (int)i.get());
            cache.put((Object)0, (Object)"RuntimeValue");
            cache.put((Object)"NewKey", (Object)"NewValue");
        }
        cacheManager = new DefaultCacheManager(cbh, true);
        try {
            cache = cacheManager.getCache(CACHE_NAME);
            i = new ByRef.Integer(0);
            cache.forEach((k, v) -> i.inc());
            AssertJUnit.assertEquals((int)(numEntries + 1), (int)i.get());
            AssertJUnit.assertEquals((Object)"RuntimeValue", (Object)cache.get((Object)0));
            AssertJUnit.assertEquals((Object)"NewValue", (Object)cache.get((Object)"NewKey"));
        }
        finally {
            cacheManager.close();
        }
    }

    static enum Marshaller {
        PROTOSTREAM,
        JAVA_SERIALIZATION;

    }
}

