/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import org.infinispan.Cache;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.KeyValueWrapper;
import org.infinispan.persistence.PersistenceUtil;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.data.Value;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public abstract class AbstractPersistenceCompatibilityTest<T>
extends SingleCacheManagerTest {
    protected static final int NUMBER_KEYS = 10;
    protected final KeyValueWrapper<String, Value, T> valueWrapper;
    protected String tmpDirectory;
    protected Version oldVersion;
    protected boolean oldSegmented;
    protected boolean newSegmented;

    protected AbstractPersistenceCompatibilityTest(KeyValueWrapper<String, Value, T> valueWrapper) {
        this.valueWrapper = valueWrapper;
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    protected String key(int index) {
        return "key-" + index;
    }

    protected Value value(int index) {
        String i = Integer.toString(index);
        return new Value(i, i);
    }

    protected static void copyFile(String src, Path dst, String fileName) throws IOException {
        InputStream is = FileLookupFactory.newInstance().lookupFile(src, Thread.currentThread().getContextClassLoader());
        File f = new File(dst.toFile(), fileName);
        Files.copy(is, f.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    protected abstract void beforeStartCache() throws Exception;

    protected void setParameters(Version oldVersion, boolean oldSegmented, boolean newSegmented) {
        this.oldVersion = oldVersion;
        this.oldSegmented = oldSegmented;
        this.newSegmented = newSegmented;
    }

    protected void doTestReadWrite() throws Exception {
        String key;
        int i;
        this.beforeStartCache();
        this.cacheManager.defineConfiguration(this.cacheName(), this.cacheConfiguration(false).build());
        Cache cache = this.cacheManager.getCache(this.cacheName());
        for (i = 0; i < 10; ++i) {
            key = this.key(i);
            if (i % 2 != 0) {
                AssertJUnit.assertNull((String)("Expected null value for key " + key), (Object)cache.get((Object)key));
                continue;
            }
            AssertJUnit.assertEquals((String)("Wrong value read for key " + key), (Object)this.value(i), (Object)this.valueWrapper.unwrap(cache.get((Object)key)));
        }
        for (i = 0; i < 10; ++i) {
            if (i % 2 == 0) continue;
            key = this.key(i);
            cache.put((Object)key, this.valueWrapper.wrap(key, this.value(i)));
        }
        for (i = 0; i < 10; ++i) {
            key = this.key(i);
            AssertJUnit.assertEquals((String)("Wrong value read for key " + key), (Object)this.value(i), (Object)this.valueWrapper.unwrap(cache.get((Object)key)));
        }
        this.cacheManager.stop();
        try (EmbeddedCacheManager cm = this.createCacheManager();){
            cm.defineConfiguration(this.cacheName(), this.cacheConfiguration(false).build());
            cache = cm.getCache(this.cacheName());
            for (int i2 = 0; i2 < 10; ++i2) {
                String key2 = this.key(i2);
                AssertJUnit.assertEquals((String)("Wrong value read for key " + key2), (Object)this.value(i2), (Object)this.valueWrapper.unwrap(cache.get((Object)key2)));
            }
        }
    }

    @Test(enabled=false)
    public void generateOldData() throws IOException {
        this.newSegmented = false;
        ConfigurationBuilder cacheBuilder = this.cacheConfiguration(true);
        this.cacheManager.defineConfiguration(this.cacheName(), cacheBuilder.build());
        Cache cache = this.cacheManager.getCache(this.cacheName());
        for (int i = 0; i < 10; ++i) {
            if (i % 2 != 0) continue;
            String key = this.key(i);
            cache.put((Object)key, this.valueWrapper.wrap(key, this.value(i)));
        }
        cache.stop();
        final Path sourcePath = Paths.get(this.tmpDirectory, new String[0]);
        final Path targetPath = Paths.get("generated", new String[0]).toAbsolutePath();
        Files.createDirectories(targetPath, new FileAttribute[0]);
        Files.walkFileTree(sourcePath, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Files.createDirectories(targetPath.resolve(sourcePath.relativize(dir)), new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.copy(file, targetPath.resolve(sourcePath.relativize(file)), StandardCopyOption.REPLACE_EXISTING);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                return FileVisitResult.TERMINATE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
        log.infof("Data generated in %s", (Object)targetPath);
    }

    @Override
    protected void setup() throws Exception {
        this.tmpDirectory = CommonsTestingUtil.tmpDirectory(this.getClass());
        Util.recursiveFileRemove((String)this.tmpDirectory);
        log.debugf("Using tmpDirectory=%s", (Object)this.tmpDirectory);
        super.setup();
    }

    @Override
    protected void teardown() {
        super.teardown();
        Util.recursiveFileRemove((String)this.tmpDirectory);
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        GlobalConfigurationBuilder builder = new GlobalConfigurationBuilder().nonClusteredDefault();
        builder.globalState().persistentLocation(this.tmpDirectory);
        builder.serialization().addContextInitializer((SerializationContextInitializer)TestDataSCI.INSTANCE);
        this.amendGlobalConfigurationBuilder(builder);
        return TestCacheManagerFactory.createCacheManager(builder, null);
    }

    protected void amendGlobalConfigurationBuilder(GlobalConfigurationBuilder builder) {
    }

    protected abstract String cacheName();

    protected abstract void configurePersistence(ConfigurationBuilder var1, boolean var2);

    protected String combinePath(String path, String more) {
        return Paths.get(path, more).toString();
    }

    protected Path getStoreLocation(String location, String qualifier) {
        return PersistenceUtil.getQualifiedLocation((GlobalConfiguration)this.cacheManager.getCacheManagerConfiguration(), (String)location, (String)this.cacheName(), (String)qualifier);
    }

    protected ConfigurationBuilder cacheConfiguration(boolean generatingData) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.LOCAL);
        builder.clustering().hash().numSegments(4);
        this.configurePersistence(builder, generatingData);
        return builder;
    }

    protected static enum Version {
        _10_1,
        _11_0,
        _12_0,
        _12_1;

    }
}

