/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.partitionhandling;

import jakarta.transaction.Transaction;
import org.infinispan.Cache;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.TransactionBoundaryCommand;
import org.infinispan.partitionhandling.BaseOptimisticTxPartitionAndMergeTest;
import org.infinispan.partitionhandling.BaseTxPartitionAndMergeTest;
import org.infinispan.transaction.tm.EmbeddedTransaction;
import org.infinispan.transaction.tm.EmbeddedTransactionManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional", "unstable"}, testName="partitionhandling.OptimisticTxPartitionAndMergeDuringCommitTest", description="ISPN-8232")
public class OptimisticTxPartitionAndMergeDuringCommitTest
extends BaseOptimisticTxPartitionAndMergeTest {
    private static final Log log = LogFactory.getLog(OptimisticTxPartitionAndMergeDuringCommitTest.class);

    public void testDegradedPartitionWithDiscard() throws Exception {
        this.doTest(BaseTxPartitionAndMergeTest.SplitMode.BOTH_DEGRADED, false, true);
    }

    public void testDegradedPartition() throws Exception {
        this.doTest(BaseTxPartitionAndMergeTest.SplitMode.BOTH_DEGRADED, false, false);
    }

    @Test(groups={"unstable"}, description="https://issues.jboss.org/browse/ISPN-8232")
    public void testOriginatorIsolatedPartitionWithDiscard() throws Exception {
        this.doTest(BaseTxPartitionAndMergeTest.SplitMode.ORIGINATOR_ISOLATED, false, true);
    }

    @Test(groups={"unstable"}, description="https://issues.jboss.org/browse/ISPN-8232")
    public void testOriginatorIsolatedPartition() throws Exception {
        this.doTest(BaseTxPartitionAndMergeTest.SplitMode.ORIGINATOR_ISOLATED, false, false);
    }

    @Test(groups={"unstable"}, description="https://issues.jboss.org/browse/ISPN-8232")
    public void testPrimaryOwnerIsolatedPartitionWithDiscard() throws Exception {
        this.doTest(BaseTxPartitionAndMergeTest.SplitMode.PRIMARY_OWNER_ISOLATED, false, true);
    }

    public void testPrimaryOwnerIsolatedPartition() throws Exception {
        this.doTest(BaseTxPartitionAndMergeTest.SplitMode.PRIMARY_OWNER_ISOLATED, false, false);
    }

    public void testSplitBeforeCommit() throws Exception {
        this.waitForClusterToForm("opt-cache");
        BaseTxPartitionAndMergeTest.KeyInfo keyInfo = this.createKeys("opt-cache");
        Cache originator = this.cache(0, "opt-cache");
        EmbeddedTransactionManager transactionManager = (EmbeddedTransactionManager)originator.getAdvancedCache().getTransactionManager();
        transactionManager.begin();
        EmbeddedTransaction transaction = transactionManager.getTransaction();
        keyInfo.putFinalValue(originator);
        AssertJUnit.assertTrue((boolean)transaction.runPrepare());
        transactionManager.suspend();
        BaseTxPartitionAndMergeTest.SplitMode.BOTH_DEGRADED.split(this);
        transactionManager.resume((Transaction)transaction);
        transaction.runCommit(false);
        this.assertLocked(this.cache(1, "opt-cache"), keyInfo.getKey1());
        this.assertLocked(this.cache(2, "opt-cache"), keyInfo.getKey2());
        this.mergeCluster("opt-cache");
        this.finalAsserts("opt-cache", keyInfo, "final-value");
    }

    @Override
    protected void checkLocksDuringPartition(BaseTxPartitionAndMergeTest.SplitMode splitMode, BaseTxPartitionAndMergeTest.KeyInfo keyInfo, boolean discard) {
        if (splitMode == BaseTxPartitionAndMergeTest.SplitMode.PRIMARY_OWNER_ISOLATED) {
            this.assertEventuallyNotLocked(this.cache(0, "opt-cache"), keyInfo.getKey1());
            this.assertEventuallyNotLocked(this.cache(0, "opt-cache"), keyInfo.getKey2());
            this.assertEventuallyNotLocked(this.cache(1, "opt-cache"), keyInfo.getKey1());
            this.assertEventuallyNotLocked(this.cache(1, "opt-cache"), keyInfo.getKey2());
            this.assertEventuallyNotLocked(this.cache(3, "opt-cache"), keyInfo.getKey1());
            this.assertEventuallyNotLocked(this.cache(3, "opt-cache"), keyInfo.getKey2());
        } else {
            this.assertLocked(this.cache(1, "opt-cache"), keyInfo.getKey1());
            this.assertLocked(this.cache(2, "opt-cache"), keyInfo.getKey2());
        }
    }

    @Override
    protected boolean forceRollback() {
        return false;
    }

    @Override
    protected Class<? extends TransactionBoundaryCommand> getCommandClass() {
        return CommitCommand.class;
    }

    @Override
    protected Log getLog() {
        return log;
    }
}

