/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntriesEvicted;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryActivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryInvalidated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryLoaded;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryPassivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryVisited;
import org.infinispan.notifications.cachelistener.annotation.TransactionCompleted;
import org.infinispan.notifications.cachelistener.annotation.TransactionRegistered;
import org.infinispan.notifications.cachelistener.event.Event;

@Listener(primaryOnly=true)
public class PrimaryOwnerCacheListener {
    List<Event> events = new ArrayList<Event>();
    boolean receivedPre;
    boolean receivedPost;
    int invocationCount;

    public void reset() {
        this.events.clear();
        this.receivedPost = false;
        this.receivedPre = false;
        this.invocationCount = 0;
    }

    public List<Event> getEvents() {
        return this.events;
    }

    public boolean isReceivedPre() {
        return this.receivedPre;
    }

    public boolean isReceivedPost() {
        return this.receivedPost;
    }

    public int getInvocationCount() {
        return this.invocationCount;
    }

    @CacheEntryActivated
    @CacheEntryCreated
    @CacheEntriesEvicted
    @CacheEntryInvalidated
    @CacheEntryLoaded
    @CacheEntryModified
    @CacheEntryPassivated
    @CacheEntryRemoved
    @CacheEntryVisited
    @TransactionCompleted
    @TransactionRegistered
    public void handle(Event e) {
        this.events.add(e);
        if (e.isPre()) {
            this.receivedPre = true;
        } else {
            this.receivedPost = true;
        }
        ++this.invocationCount;
    }
}

