/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.data.CountMarshallingPojo;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="marshall.InvalidatedMarshalledValueTest")
public class InvalidatedMarshalledValueTest
extends MultipleCacheManagersTest {
    private static final String POJO_NAME = InvalidatedMarshalledValueTest.class.getName();

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder invlSync = InvalidatedMarshalledValueTest.getDefaultClusteredCacheConfig(CacheMode.INVALIDATION_SYNC, false);
        invlSync.memory().storageType(StorageType.BINARY);
        this.createClusteredCaches(2, "invlSync", TestDataSCI.INSTANCE, invlSync);
    }

    public void testModificationsOnSameCustomKey() {
        CountMarshallingPojo.reset(POJO_NAME);
        Cache cache1 = this.cache(0, "invlSync");
        Cache cache2 = this.cache(1, "invlSync");
        CountMarshallingPojo key = new CountMarshallingPojo(POJO_NAME, 1);
        cache2.put((Object)key, (Object)"1");
        cache1.put((Object)key, (Object)"2");
        this.assertSerializationCounts(2, 0);
        cache1.put((Object)key, (Object)"3");
        this.assertSerializationCounts(3, 0);
    }

    private void assertSerializationCounts(int expectedSerializationCount, int expectedDeserializationCount) {
        AssertJUnit.assertEquals((String)"Wrong marshall count", (int)expectedSerializationCount, (int)CountMarshallingPojo.getMarshallCount(POJO_NAME));
        AssertJUnit.assertEquals((String)"Wrong unmarshall count", (int)expectedDeserializationCount, (int)CountMarshallingPojo.getUnmarshallCount(POJO_NAME));
    }
}

