/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.singlelock;

import jakarta.transaction.RollbackException;
import jakarta.transaction.Transaction;
import java.util.HashMap;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.infinispan.transaction.tm.EmbeddedTransaction;
import org.infinispan.transaction.tm.EmbeddedTransactionManager;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lock.singlelock.MainOwnerChangesLockTest")
@CleanupAfterMethod
public class MainOwnerChangesLockTest
extends MultipleCacheManagersTest {
    public static final int NUM_KEYS = 100;
    private ConfigurationBuilder dccc;

    @Override
    protected void createCacheManagers() throws Throwable {
        this.dccc = MainOwnerChangesLockTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true, true);
        this.dccc.transaction().transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup());
        this.dccc.clustering().hash().l1().disable().locking().lockAcquisitionTimeout(TestingUtil.shortTimeoutMillis());
        this.dccc.clustering().stateTransfer().fetchInMemoryState(true);
        this.createCluster(TestDataSCI.INSTANCE, this.dccc, 2);
        this.waitForClusterToForm();
    }

    public void testLocalTxLockMigration() throws Exception {
        this.testLockMigration(0);
    }

    public void testRemoteTxLockMigration() throws Exception {
        this.testLockMigration(1);
    }

    private void testLockMigration(int nodeThatPuts) throws Exception {
        HashMap<Object, EmbeddedTransaction> key2Tx = new HashMap<Object, EmbeddedTransaction>();
        for (int i = 0; i < 100; ++i) {
            Object key = this.getKeyForCache(0);
            if (key2Tx.containsKey(key)) continue;
            this.embeddedTm(nodeThatPuts).begin();
            this.cache(nodeThatPuts).put(key, key);
            EmbeddedTransaction tx = this.embeddedTm(nodeThatPuts).getTransaction();
            tx.runPrepare();
            this.embeddedTm(nodeThatPuts).suspend();
            key2Tx.put(key, tx);
            this.assertLocked(0, key);
        }
        log.trace((Object)"Lock transfer happens here");
        this.addClusterEnabledCacheManager(TestDataSCI.INSTANCE, this.dccc);
        this.waitForClusterToForm();
        Object migratedKey = null;
        LocalizedCacheTopology cacheTopology = this.advancedCache(2).getDistributionManager().getCacheTopology();
        for (Object key : key2Tx.keySet()) {
            if (!cacheTopology.getDistribution(key).isPrimary()) continue;
            migratedKey = key;
            break;
        }
        if (migratedKey == null) {
            log.trace((Object)"No key migrated to new owner.");
        } else {
            log.trace((Object)("migratedKey = " + String.valueOf(migratedKey)));
            this.embeddedTm(2).begin();
            this.cache(2).put(migratedKey, (Object)"someValue");
            try {
                this.embeddedTm(2).commit();
                AssertJUnit.fail((String)"RollbackException should have been thrown here.");
            }
            catch (RollbackException rollbackException) {
                // empty catch block
            }
        }
        log.trace((Object)"About to commit existing transactions.");
        log.trace((Object)"Committing the tx to the new node.");
        for (Transaction tx : key2Tx.values()) {
            this.tm(nodeThatPuts).resume(tx);
            this.embeddedTm(nodeThatPuts).getTransaction().runCommit(false);
        }
        for (Object key : key2Tx.keySet()) {
            Object value = this.getValue(key);
            AssertJUnit.assertEquals(key, (Object)value);
        }
    }

    private Object getValue(Object key) {
        log.tracef("Checking key: %s", key);
        InternalCacheEntry d0 = this.advancedCache(0).getDataContainer().get(key);
        InternalCacheEntry d1 = this.advancedCache(1).getDataContainer().get(key);
        InternalCacheEntry d2 = this.advancedCache(2).getDataContainer().get(key);
        if (d0 == null) {
            assert (this.sameValue(d1, d2));
            return d1.getValue();
        }
        if (d1 == null) {
            assert (this.sameValue(d0, d2));
            return d0.getValue();
        }
        if (d2 == null) {
            assert (this.sameValue(d0, d1));
            return d0.getValue();
        }
        throw new RuntimeException();
    }

    private boolean sameValue(InternalCacheEntry d1, InternalCacheEntry d2) {
        return d1.getValue().equals(d2.getValue());
    }

    private EmbeddedTransactionManager embeddedTm(int cacheIndex) {
        return (EmbeddedTransactionManager)this.tm(cacheIndex);
    }
}

