/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock;

import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.BaseAsyncInterceptor;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

class FailInterceptor
extends BaseAsyncInterceptor {
    private static final Log log = LogFactory.getLog(FailInterceptor.class);
    public Queue<Action> actions = new LinkedBlockingQueue<Action>();

    FailInterceptor() {
    }

    public Object visitCommand(InvocationContext ctx, VisitableCommand command) throws Throwable {
        Action action = this.actions.peek();
        if (action == null || command.getClass() != action.commandClass) {
            return this.invokeNext(ctx, command);
        }
        --action.count;
        if (action.count <= 0) {
            this.actions.poll();
        }
        switch (action.type.ordinal()) {
            case 0: {
                return this.invokeNext(ctx, command);
            }
            case 1: {
                log.debugf("Skipped executing command %s", (Object)command);
                return action.returnValue;
            }
            case 2: {
                throw new CacheException("Forced failure executing command " + String.valueOf(command));
            }
        }
        throw new CacheException("Unexpected FailInterceptor action type: " + String.valueOf((Object)action.type));
    }

    public void failFor(Class<? extends ReplicableCommand> commandClass) {
        this.failFor(commandClass, Integer.MAX_VALUE);
    }

    public void failFor(Class<? extends ReplicableCommand> commandClass, int failCount) {
        this.actions.add(new Action(ActionType.FAIL, commandClass, null, failCount));
    }

    public void skipFor(Class<? extends ReplicableCommand> commandClass, Object returnValue) {
        this.skipFor(commandClass, returnValue, Integer.MAX_VALUE);
    }

    public void skipFor(Class<? extends ReplicableCommand> commandClass, Object returnValue, int skipCount) {
        this.actions.add(new Action(ActionType.SKIP, commandClass, returnValue, skipCount));
    }

    public void execFor(Class<? extends ReplicableCommand> commandClass) {
        this.execFor(commandClass, Integer.MAX_VALUE);
    }

    public void execFor(Class<? extends ReplicableCommand> commandClass, int execCount) {
        this.actions.add(new Action(ActionType.EXEC, commandClass, null, execCount));
    }

    private static class Action {
        public Class<?> commandClass;
        public ActionType type;
        public Object returnValue;
        public int count;

        private Action(ActionType type, Class<?> commandClass, Object returnValue, int count) {
            this.commandClass = commandClass;
            this.type = type;
            this.returnValue = returnValue;
            this.count = count;
        }
    }

    private static enum ActionType {
        EXEC,
        SKIP,
        FAIL;

    }
}

