/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import javax.management.ObjectName;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.jmx.TestMBeanServerLookup;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.infinispan.transaction.tm.EmbeddedTransactionManager;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="jmx.MvccLockManagerMBeanTest")
public class MvccLockManagerMBeanTest
extends SingleCacheManagerTest {
    private static final int CONCURRENCY_LEVEL = 129;
    private ObjectName lockManagerObjName;
    private final MBeanServerLookup mBeanServerLookup = TestMBeanServerLookup.create();
    private static final String JMX_DOMAIN = MvccLockManagerMBeanTest.class.getSimpleName();

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder configuration = this.getDefaultStandaloneCacheConfig(true);
        configuration.locking().concurrencyLevel(129).useLockStriping(true).transaction().transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup());
        GlobalConfigurationBuilder globalConfiguration = new GlobalConfigurationBuilder();
        globalConfiguration.jmx().enabled(true).domain(JMX_DOMAIN).mBeanServerLookup(this.mBeanServerLookup);
        this.cacheManager = TestCacheManagerFactory.createCacheManager(globalConfiguration, configuration);
        this.cacheManager.defineConfiguration("test", configuration.build());
        this.cache = this.cacheManager.getCache("test");
        this.lockManagerObjName = TestingUtil.getCacheObjectName(JMX_DOMAIN, "test(local)", "LockManager");
        return this.cacheManager;
    }

    public void testJmxOperationMetadata() throws Exception {
        TestingUtil.checkMBeanOperationParameterNaming(this.mBeanServerLookup.getMBeanServer(), this.lockManagerObjName);
    }

    public void testConcurrencyLevel() throws Exception {
        this.assertAttributeValue("ConcurrencyLevel", 129);
    }

    public void testNumberOfLocksHeld() throws Exception {
        EmbeddedTransactionManager tm = (EmbeddedTransactionManager)this.tm();
        tm.begin();
        this.cache.put((Object)"key", (Object)"value");
        tm.getTransaction().runPrepare();
        this.assertAttributeValue("NumberOfLocksHeld", 1);
        tm.getTransaction().runCommit(false);
        this.assertAttributeValue("NumberOfLocksHeld", 0);
    }

    public void testNumberOfLocksAvailable() throws Exception {
        EmbeddedTransactionManager tm = (EmbeddedTransactionManager)this.tm();
        int initialAvailable = this.getAttrValue("NumberOfLocksAvailable");
        tm.begin();
        this.cache.put((Object)"key", (Object)"value");
        tm.getTransaction().runPrepare();
        this.assertAttributeValue("NumberOfLocksHeld", 1);
        this.assertAttributeValue("NumberOfLocksAvailable", initialAvailable - 1);
        tm.getTransaction().runCommit(true);
        this.assertAttributeValue("NumberOfLocksAvailable", initialAvailable);
        this.assertAttributeValue("NumberOfLocksHeld", 0);
    }

    private void assertAttributeValue(String attrName, int expectedVal) throws Exception {
        int cl = this.getAttrValue(attrName);
        assert (cl == expectedVal) : "expected " + expectedVal + ", but received " + cl;
    }

    private int getAttrValue(String attrName) throws Exception {
        return Integer.parseInt(this.mBeanServerLookup.getMBeanServer().getAttribute(this.lockManagerObjName, attrName).toString());
    }
}

