/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import java.lang.reflect.Method;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.jmx.TestMBeanServerLookup;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.jmx.JmxDomainConflictException;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.EmbeddedCacheManagerStartupException;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional", "smoke"}, testName="jmx.CacheMBeanTest")
public class CacheMBeanTest
extends MultipleCacheManagersTest {
    private static final Log log = LogFactory.getLog(CacheMBeanTest.class);
    public static final String JMX_DOMAIN = CacheMBeanTest.class.getSimpleName();
    private final MBeanServerLookup mBeanServerLookup = TestMBeanServerLookup.create();

    @Override
    protected void createCacheManagers() throws Exception {
        GlobalConfigurationBuilder globalConfiguration = new GlobalConfigurationBuilder();
        globalConfiguration.jmx().enabled(true).domain(JMX_DOMAIN).mBeanServerLookup(this.mBeanServerLookup);
        ConfigurationBuilder configuration = new ConfigurationBuilder();
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createCacheManager(globalConfiguration, configuration);
        this.registerCacheManager(new CacheContainer[]{cacheManager});
        cacheManager.getCache();
    }

    public void testJmxOperationMetadata() throws Exception {
        ObjectName name = TestingUtil.getCacheObjectName(JMX_DOMAIN, this.getDefaultCacheName() + "(local)");
        TestingUtil.checkMBeanOperationParameterNaming(this.mBeanServerLookup.getMBeanServer(), name);
    }

    public void testStartStopManagedOperations() throws Exception {
        ObjectName cacheObjectName = TestingUtil.getCacheObjectName(JMX_DOMAIN, this.getDefaultCacheName() + "(local)");
        ObjectName cacheManagerObjectName = TestingUtil.getCacheManagerObjectName(JMX_DOMAIN);
        MBeanServer server = this.mBeanServerLookup.getMBeanServer();
        server.invoke(cacheManagerObjectName, "startCache", new Object[0], new String[0]);
        AssertJUnit.assertEquals((Object)ComponentStatus.RUNNING.toString(), (Object)server.getAttribute(cacheObjectName, "CacheStatus"));
        AssertJUnit.assertEquals((Object)"1", (Object)server.getAttribute(cacheManagerObjectName, "CreatedCacheCount"));
        AssertJUnit.assertEquals((Object)"1", (Object)server.getAttribute(cacheManagerObjectName, "RunningCacheCount"));
        server.invoke(cacheObjectName, "stop", new Object[0], new String[0]);
        AssertJUnit.assertFalse((String)(String.valueOf(cacheObjectName) + " should NOT be registered"), (boolean)server.isRegistered(cacheObjectName));
        AssertJUnit.assertEquals((Object)"1", (Object)server.getAttribute(cacheManagerObjectName, "CreatedCacheCount"));
        AssertJUnit.assertEquals((Object)"0", (Object)server.getAttribute(cacheManagerObjectName, "RunningCacheCount"));
        server.invoke(cacheManagerObjectName, "startCache", new Object[]{this.getDefaultCacheName()}, new String[]{String.class.getName()});
        AssertJUnit.assertEquals((Object)ComponentStatus.RUNNING.toString(), (Object)server.getAttribute(cacheObjectName, "CacheStatus"));
        AssertJUnit.assertEquals((Object)"1", (Object)server.getAttribute(cacheManagerObjectName, "CreatedCacheCount"));
        AssertJUnit.assertEquals((Object)"1", (Object)server.getAttribute(cacheManagerObjectName, "RunningCacheCount"));
        server.invoke(cacheObjectName, "stop", new Object[0], new String[0]);
        AssertJUnit.assertFalse((String)(String.valueOf(cacheObjectName) + " should NOT be registered"), (boolean)server.isRegistered(cacheObjectName));
        AssertJUnit.assertEquals((Object)"1", (Object)server.getAttribute(cacheManagerObjectName, "CreatedCacheCount"));
        AssertJUnit.assertEquals((Object)"0", (Object)server.getAttribute(cacheManagerObjectName, "RunningCacheCount"));
        server.invoke(cacheManagerObjectName, "startCache", new Object[]{this.getDefaultCacheName()}, new String[]{String.class.getName()});
        AssertJUnit.assertEquals((Object)ComponentStatus.RUNNING.toString(), (Object)server.getAttribute(cacheObjectName, "CacheStatus"));
        AssertJUnit.assertEquals((Object)"1", (Object)server.getAttribute(cacheManagerObjectName, "CreatedCacheCount"));
        AssertJUnit.assertEquals((Object)"1", (Object)server.getAttribute(cacheManagerObjectName, "RunningCacheCount"));
        server.invoke(cacheObjectName, "stop", new Object[0], new String[0]);
        AssertJUnit.assertFalse((String)(String.valueOf(cacheObjectName) + " should NOT be registered"), (boolean)server.isRegistered(cacheObjectName));
        AssertJUnit.assertEquals((Object)"1", (Object)server.getAttribute(cacheManagerObjectName, "CreatedCacheCount"));
        AssertJUnit.assertEquals((Object)"0", (Object)server.getAttribute(cacheManagerObjectName, "RunningCacheCount"));
    }

    public void testManagerStopRemovesCacheMBean(Method m) throws Exception {
        String otherJmxDomain = JMX_DOMAIN + "_" + m.getName();
        ObjectName defaultOn = TestingUtil.getCacheObjectName(otherJmxDomain, this.getDefaultCacheName() + "(local)");
        ObjectName galderOn = TestingUtil.getCacheObjectName(otherJmxDomain, "galder(local)");
        ObjectName managerON = TestingUtil.getCacheManagerObjectName(otherJmxDomain);
        GlobalConfigurationBuilder gc = new GlobalConfigurationBuilder();
        gc.jmx().enabled(true).domain(otherJmxDomain).mBeanServerLookup(this.mBeanServerLookup);
        ConfigurationBuilder c = new ConfigurationBuilder();
        c.statistics().enabled(true);
        EmbeddedCacheManager otherContainer = TestCacheManagerFactory.createCacheManager(gc, c);
        otherContainer.defineConfiguration("galder", new ConfigurationBuilder().build());
        this.registerCacheManager(new CacheContainer[]{otherContainer});
        MBeanServer server = this.mBeanServerLookup.getMBeanServer();
        server.invoke(managerON, "startCache", new Object[0], new String[0]);
        server.invoke(managerON, "startCache", new Object[]{"galder"}, new String[]{String.class.getName()});
        AssertJUnit.assertEquals((Object)ComponentStatus.RUNNING.toString(), (Object)server.getAttribute(defaultOn, "CacheStatus"));
        AssertJUnit.assertEquals((Object)ComponentStatus.RUNNING.toString(), (Object)server.getAttribute(galderOn, "CacheStatus"));
        otherContainer.stop();
        try {
            log.info((Object)server.getMBeanInfo(managerON));
            AssertJUnit.fail((String)("Failure expected, " + String.valueOf(managerON) + " shouldn't be registered in mbean server"));
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            // empty catch block
        }
        try {
            log.info((Object)server.getMBeanInfo(defaultOn));
            AssertJUnit.fail((String)("Failure expected, " + String.valueOf(defaultOn) + " shouldn't be registered in mbean server"));
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            // empty catch block
        }
        try {
            log.info((Object)server.getMBeanInfo(galderOn));
            AssertJUnit.fail((String)("Failure expected, " + String.valueOf(galderOn) + " shouldn't be registered in mbean server"));
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            // empty catch block
        }
    }

    public void testDuplicateJmxDomainOnlyCacheExposesJmxStatistics() {
        GlobalConfigurationBuilder gc = new GlobalConfigurationBuilder();
        gc.jmx().enabled(true).domain(JMX_DOMAIN).mBeanServerLookup(this.mBeanServerLookup);
        ConfigurationBuilder c = new ConfigurationBuilder();
        c.statistics().enabled(true);
        Exceptions.expectException(EmbeddedCacheManagerStartupException.class, JmxDomainConflictException.class, () -> TestCacheManagerFactory.createCacheManager(gc, c));
    }

    public void testAvoidLeakOfCacheMBeanWhenCacheStatisticsDisabled(Method m) {
        final String otherJmxDomain = "jmx_" + m.getName();
        GlobalConfigurationBuilder gc = new GlobalConfigurationBuilder();
        gc.jmx().enabled(true).domain(otherJmxDomain).mBeanServerLookup(this.mBeanServerLookup);
        ConfigurationBuilder c = new ConfigurationBuilder();
        c.statistics().enabled(false);
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createCacheManager(gc, c)){

            @Override
            public void call() {
                this.cm.getCache();
                MBeanServer server = CacheMBeanTest.this.mBeanServerLookup.getMBeanServer();
                ObjectName cacheObjectName = TestingUtil.getCacheObjectName(otherJmxDomain, CacheMBeanTest.this.getDefaultCacheName() + "(local)");
                AssertJUnit.assertTrue((String)(String.valueOf(cacheObjectName) + " should be registered"), (boolean)server.isRegistered(cacheObjectName));
                TestingUtil.killCacheManagers(this.cm);
                AssertJUnit.assertFalse((String)(String.valueOf(cacheObjectName) + " should NOT be registered"), (boolean)server.isRegistered(cacheObjectName));
            }
        });
    }
}

