/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import java.util.Arrays;
import java.util.Collection;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.jmx.TestMBeanServerLookup;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.partitionhandling.PartitionHandling;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="jmx.CacheAvailabilityJmxTest")
public class CacheAvailabilityJmxTest
extends MultipleCacheManagersTest {
    private final MBeanServerLookup mBeanServerLookup = TestMBeanServerLookup.create();

    @Override
    protected void createCacheManagers() throws Throwable {
        this.addClusterEnabledCacheManager(this.getGlobalConfigurationBuilder("r1"), this.getConfigurationBuilder());
        this.addClusterEnabledCacheManager(this.getGlobalConfigurationBuilder("r1"), this.getConfigurationBuilder());
        this.waitForClusterToForm();
    }

    private ConfigurationBuilder getConfigurationBuilder() {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.clustering().cacheMode(CacheMode.DIST_SYNC).stateTransfer().awaitInitialTransfer(false).partitionHandling().whenSplit(PartitionHandling.DENY_READ_WRITES);
        return cb;
    }

    private GlobalConfigurationBuilder getGlobalConfigurationBuilder(String rackId) {
        int nodeIndex = this.cacheManagers.size();
        GlobalConfigurationBuilder gcb = GlobalConfigurationBuilder.defaultClusteredBuilder();
        gcb.jmx().enabled(true).domain(this.getClass().getSimpleName() + nodeIndex).mBeanServerLookup(this.mBeanServerLookup).transport().rackId(rackId);
        return gcb;
    }

    public void testAvailabilityChange() throws Exception {
        MBeanServer mBeanServer = this.mBeanServerLookup.getMBeanServer();
        String cacheName = (String)this.manager(0).getCacheManagerConfiguration().defaultCacheName().get();
        String domain0 = this.manager(1).getCacheManagerConfiguration().jmx().domain();
        ObjectName cacheName0 = TestingUtil.getCacheObjectName(domain0, cacheName + "(dist_sync)");
        String domain1 = this.manager(1).getCacheManagerConfiguration().jmx().domain();
        ObjectName cacheName1 = TestingUtil.getCacheObjectName(domain1, cacheName + "(dist_sync)");
        DistributionManager dm0 = this.advancedCache(0).getDistributionManager();
        Assert.assertEquals(Arrays.asList(this.address(0), this.address(1)), (Collection)dm0.getCacheTopology().getCurrentCH().getMembers());
        AssertJUnit.assertNull((Object)dm0.getCacheTopology().getPendingCH());
        AssertJUnit.assertTrue((boolean)mBeanServer.isRegistered(cacheName0));
        Assert.assertEquals((Object)"AVAILABLE", (Object)mBeanServer.getAttribute(cacheName0, "CacheAvailability"));
        Assert.assertEquals((Object)"AVAILABLE", (Object)mBeanServer.getAttribute(cacheName1, "CacheAvailability"));
        log.debugf("Entering degraded mode", new Object[0]);
        mBeanServer.setAttribute(cacheName0, new Attribute("CacheAvailability", "DEGRADED_MODE"));
        CacheAvailabilityJmxTest.eventually(() -> {
            Object availability0 = mBeanServer.getAttribute(cacheName0, "CacheAvailability");
            Object availability1 = mBeanServer.getAttribute(cacheName1, "CacheAvailability");
            return "DEGRADED_MODE".equals(availability0) && "DEGRADED_MODE".equals(availability1);
        });
        log.debugf("Starting 2 new nodes", new Object[0]);
        this.addClusterEnabledCacheManager(this.getGlobalConfigurationBuilder("r2"), this.getConfigurationBuilder());
        this.addClusterEnabledCacheManager(this.getGlobalConfigurationBuilder("r2"), this.getConfigurationBuilder());
        this.cache(2);
        this.cache(3);
        Thread.sleep(1000L);
        Assert.assertEquals(Arrays.asList(this.address(0), this.address(1)), (Collection)dm0.getCacheTopology().getCurrentCH().getMembers());
        AssertJUnit.assertNull((Object)dm0.getCacheTopology().getPendingCH());
        Assert.assertEquals((Object)"DEGRADED_MODE", (Object)mBeanServer.getAttribute(cacheName0, "CacheAvailability"));
        Assert.assertEquals((Object)"DEGRADED_MODE", (Object)mBeanServer.getAttribute(cacheName1, "CacheAvailability"));
        log.debugf("Back to available mode", new Object[0]);
        mBeanServer.setAttribute(cacheName0, new Attribute("CacheAvailability", "AVAILABLE"));
        CacheAvailabilityJmxTest.eventually(() -> {
            Object availability0 = mBeanServer.getAttribute(cacheName0, "CacheAvailability");
            Object availability1 = mBeanServer.getAttribute(cacheName1, "CacheAvailability");
            return "AVAILABLE".equals(availability0) && "AVAILABLE".equals(availability1);
        });
        TestingUtil.waitForNoRebalance(this.cache(0), this.cache(1), this.cache(2), this.cache(3));
    }
}

