/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.invalidation;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.DataContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TransportFlags;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="invalidation.InvalidationPreloadTest")
@CleanupAfterMethod
public class InvalidationPreloadTest
extends MultipleCacheManagersTest {
    private boolean shared;

    @Override
    public Object[] factory() {
        return new Object[]{new InvalidationPreloadTest().shared(true).transactional(false), new InvalidationPreloadTest().shared(true).transactional(true), new InvalidationPreloadTest().shared(false).transactional(false), new InvalidationPreloadTest().shared(false).transactional(true)};
    }

    @Override
    protected String[] parameterNames() {
        return new String[]{"tx", "shared"};
    }

    @Override
    protected Object[] parameterValues() {
        return new Object[]{this.transactional, this.shared};
    }

    @Override
    protected void createCacheManagers() throws Throwable {
    }

    public void testPreloadOnStart() throws PersistenceException {
        ConfigurationBuilder configuration = new ConfigurationBuilder();
        configuration.clustering().cacheMode(CacheMode.INVALIDATION_SYNC);
        configuration.transaction().transactionMode(this.transactionMode());
        DummyInMemoryStoreConfigurationBuilder dimsConfiguration = (DummyInMemoryStoreConfigurationBuilder)configuration.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class);
        ((DummyInMemoryStoreConfigurationBuilder)dimsConfiguration.storeName(this.getTestName()).preload(true)).shared(this.shared);
        EmbeddedCacheManager cm1 = this.addClusterEnabledCacheManager(TestDataSCI.INSTANCE, configuration, new TransportFlags().withFD(false));
        Cache c1 = cm1.getCache();
        c1.put((Object)"k0", (Object)"v0");
        this.assertKeys((Cache<String, String>)c1);
        cm1.stop();
        EmbeddedCacheManager cm2 = this.addClusterEnabledCacheManager(TestDataSCI.INSTANCE, configuration, new TransportFlags().withFD(false));
        Cache c2 = cm2.getCache();
        this.assertKeys((Cache<String, String>)c2);
        if (this.shared) {
            EmbeddedCacheManager cm3 = this.addClusterEnabledCacheManager(TestDataSCI.INSTANCE, configuration, new TransportFlags().withFD(false));
            Cache c3 = cm3.getCache();
            this.assertKeys((Cache<String, String>)c3);
        }
    }

    private void assertKeys(Cache<String, String> cache) {
        DataContainer dc = cache.getAdvancedCache().getDataContainer();
        AssertJUnit.assertEquals((int)1, (int)dc.size());
        DummyInMemoryStore cs = (DummyInMemoryStore)TestingUtil.getFirstStore(cache);
        AssertJUnit.assertEquals((long)1L, (long)cs.size());
    }

    private InvalidationPreloadTest shared(boolean shared) {
        this.shared = shared;
        return this;
    }
}

