/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.globalstate;

import java.io.File;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.infinispan.Cache;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.util.concurrent.AggregateCompletionStage;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.globalstate.AbstractGlobalStateRestartTest;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.infinispan.test.TestingUtil;
import org.infinispan.topology.MissingMembersException;
import org.infinispan.topology.PersistentUUID;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="globalstate.ThreeNodeTopologyReinstallTest", groups={"functional"})
public class ThreeNodeTopologyReinstallTest
extends AbstractGlobalStateRestartTest {
    private CacheMode cacheMode;

    private int getNumOwners() {
        return this.getClusterSize() - 1;
    }

    @Override
    protected int getClusterSize() {
        return 3;
    }

    @Override
    protected void applyCacheManagerClusteringConfiguration(ConfigurationBuilder config) {
        config.clustering().cacheMode(this.cacheMode).hash().numOwners(this.getNumOwners());
    }

    @Override
    protected void applyCacheManagerClusteringConfiguration(String id, ConfigurationBuilder config) {
        this.applyCacheManagerClusteringConfiguration(config);
        config.clustering().stateTransfer().timeout(90L, TimeUnit.SECONDS);
        config.persistence().addSoftIndexFileStore().dataLocation(CommonsTestingUtil.tmpDirectory((String[])new String[]{this.getClass().getSimpleName(), id, "data"})).indexLocation(CommonsTestingUtil.tmpDirectory((String[])new String[]{this.getClass().getSimpleName(), id, "index"}));
    }

    public void testReinstallTopologyByForce() throws Exception {
        this.executeTestRestart(true);
    }

    public void testReinstallTopologySafely() throws Exception {
        this.executeTestRestart(false);
    }

    private void executeTestRestart(boolean force) throws Exception {
        int j;
        int i;
        boolean possibleDataLoss = !this.cacheMode.isReplicated() && force;
        Map<JGroupsAddress, PersistentUUID> addressMappings = this.createInitialCluster();
        this.cache(0, "testCache").shutdown();
        TestingUtil.killCacheManagers(this.cacheManagers);
        for (i = 0; i < this.getClusterSize(); ++i) {
            String persistentLocation = this.manager(i).getCacheManagerConfiguration().globalState().persistentLocation();
            Object[] listFiles = new File(persistentLocation).listFiles((dir, name) -> name.equals("testCache.state"));
            AssertJUnit.assertEquals((String)Arrays.toString(listFiles), (int)1, (int)listFiles.length);
        }
        this.cacheManagers.clear();
        for (i = 0; i < this.getClusterSize() - this.getNumOwners(); ++i) {
            this.createStatefulCacheManager(Character.toString((char)(65 + i)), false);
            TestingUtil.blockUntilViewsReceived(15000, this.getCaches("testCache"));
            GlobalComponentRegistry gcr = TestingUtil.extractGlobalComponentRegistry((CacheContainer)this.manager(i));
            if (this.cacheMode.isReplicated()) continue;
            Exceptions.expectException(MissingMembersException.class, (String)"ISPN000694: Cache 'testCache' has number of owners \\d but is missing too many members \\(\\d\\/3\\) to reinstall topology$", () -> gcr.getClusterTopologyManager().useCurrentTopologyAsStable("testCache", false));
        }
        Assertions.assertThat((boolean)TestingUtil.extractGlobalComponentRegistry((CacheContainer)this.manager(0)).getClusterTopologyManager().isRebalancingEnabled("testCache")).isFalse();
        this.assertOperationsFail();
        if (!force) {
            this.createStatefulCacheManager(Character.toString((char)(65 + i++)), false);
            TestingUtil.blockUntilViewsReceived(15000, this.getCaches("testCache"));
        }
        for (int j2 = 0; j2 < this.cacheManagers.size(); ++j2) {
            EmbeddedCacheManager ecm = this.manager(j2);
            if (!ecm.isCoordinator()) continue;
            boolean stableTopology = TestingUtil.extractGlobalComponentRegistry((CacheContainer)ecm).getClusterTopologyManager().useCurrentTopologyAsStable("testCache", force);
            Assertions.assertThat((boolean)stableTopology).isTrue();
            break;
        }
        this.waitForClusterToForm("testCache");
        AggregateCompletionStage topologyInstall = CompletionStages.aggregateCompletionStage();
        for (j = 0; j < this.cacheManagers.size(); ++j) {
            GlobalComponentRegistry gcr = TestingUtil.extractGlobalComponentRegistry((CacheContainer)this.manager(j));
            topologyInstall.dependsOn(gcr.getLocalTopologyManager().stableTopologyCompletion("testCache"));
        }
        CompletableFutures.uncheckedAwait(topologyInstall.freeze().toCompletableFuture(), (long)30L, (TimeUnit)TimeUnit.SECONDS);
        if (possibleDataLoss) {
            for (j = 0; j < this.cacheManagers.size(); ++j) {
                AssertJUnit.assertFalse((boolean)this.cache(j, "testCache").isEmpty());
                AssertJUnit.assertTrue((this.cache(j, "testCache").size() < 100 ? 1 : 0) != 0);
            }
        } else {
            this.checkData();
        }
        while (i < this.getClusterSize()) {
            this.createStatefulCacheManager(Character.toString((char)(65 + i)), false);
            ++i;
        }
        this.waitForClusterToForm("testCache");
        this.checkClusterRestartedCorrectly(addressMappings);
        if (possibleDataLoss) {
            for (j = 0; j < this.getClusterSize(); ++j) {
                AssertJUnit.assertFalse((boolean)this.cache(j, "testCache").isEmpty());
            }
        } else {
            this.checkData();
        }
    }

    private void assertOperationsFail() {
        for (int i = 0; i < this.cacheManagers.size(); ++i) {
            for (int v = 0; v < 100; ++v) {
                Cache cache = this.cache(i, "testCache");
                String key = String.valueOf(v);
                Exceptions.expectException(MissingMembersException.class, (String)"ISPN000689: Recovering cache 'testCache' but there are missing members, known members \\[.*\\] of a total of 3$", () -> cache.get((Object)key));
            }
        }
    }

    private ThreeNodeTopologyReinstallTest withCacheMode(CacheMode mode) {
        this.cacheMode = mode;
        return this;
    }

    @Override
    public Object[] factory() {
        return new Object[]{new ThreeNodeTopologyReinstallTest().withCacheMode(CacheMode.DIST_SYNC), new ThreeNodeTopologyReinstallTest().withCacheMode(CacheMode.REPL_SYNC)};
    }

    @Override
    protected String parameters() {
        return String.format("[cacheMode=%s]", this.cacheMode);
    }
}

