/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.globalstate;

import java.io.File;
import java.util.Arrays;
import java.util.stream.IntStream;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.globalstate.ConfigurationStorage;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="globalstate.GlobalStateRestartWithCacheTest")
public class GlobalStateRestartWithCacheTest
extends MultipleCacheManagersTest {
    private static final String CACHE_NAME = "testCache";

    @Override
    @AfterClass(alwaysRun=true)
    protected void destroy() {
        super.destroy();
        Util.recursiveFileRemove((String)CommonsTestingUtil.tmpDirectory((String[])new String[]{this.getClass().getSimpleName()}));
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        Util.recursiveFileRemove((String)CommonsTestingUtil.tmpDirectory((String[])new String[]{this.getClass().getSimpleName()}));
        this.createStatefulCacheManagers();
    }

    private void createStatefulCacheManagers() {
        IntStream.range(0, 2).forEach(this::createStatefulCacheManager);
    }

    private void createStatefulCacheManager(int index) {
        String stateDirectory = CommonsTestingUtil.tmpDirectory((String[])new String[]{this.getClass().getSimpleName(), Integer.toString(index)});
        GlobalConfigurationBuilder global = GlobalConfigurationBuilder.defaultClusteredBuilder();
        global.globalState().enable().persistentLocation(stateDirectory).configurationStorage(ConfigurationStorage.OVERLAY);
        this.addClusterEnabledCacheManager(global, null);
    }

    public void testCacheDeletionAfterRestart() {
        Configuration cacheConfig = new ConfigurationBuilder().clustering().cacheMode(CacheMode.DIST_SYNC).build();
        this.manager(0).administration().createCache(CACHE_NAME, cacheConfig);
        this.waitForClusterToForm(CACHE_NAME);
        this.manager(0).shutdownAllCaches();
        for (EmbeddedCacheManager manager : this.managers()) {
            manager.stop();
        }
        for (int i = 0; i < 2; ++i) {
            String persistentLocation = this.manager(i).getCacheManagerConfiguration().globalState().persistentLocation();
            Object[] listFiles = new File(persistentLocation).listFiles((dir, name) -> name.equals("testCache.state"));
            AssertJUnit.assertEquals((String)Arrays.toString(listFiles), (int)1, (int)listFiles.length);
        }
        this.cacheManagers.clear();
        this.createStatefulCacheManagers();
        this.manager(0).administration().removeCache(CACHE_NAME);
    }

    public DefaultCacheManager manager(int i) {
        return (DefaultCacheManager)this.cacheManagers.get(i);
    }
}

