/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional;

import java.io.Serializable;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.infinispan.AdvancedCache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.distribution.MagicKey;
import org.infinispan.functional.FunctionalMap;
import org.infinispan.functional.Traversable;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.infinispan.functional.impl.ReadWriteMapImpl;
import org.infinispan.functional.impl.WriteOnlyMapImpl;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.CountingRpcManager;
import org.infinispan.util.function.SerializableBiConsumer;
import org.infinispan.util.function.SerializableBiFunction;
import org.infinispan.util.function.SerializableConsumer;
import org.infinispan.util.function.SerializableFunction;
import org.testng.AssertJUnit;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="functional.FunctionalNoopDoesNotGoToBackupTest")
public class FunctionalNoopDoesNotGoToBackupTest
extends MultipleCacheManagersTest {
    private FunctionalMap.ReadWriteMap<Object, Object> rw0;
    private FunctionalMap.ReadWriteMap<Object, Object> rw1;
    private FunctionalMap.WriteOnlyMap<Object, Object> wo0;
    private FunctionalMap.WriteOnlyMap<Object, Object> wo1;
    private MagicKey key;
    private CountingRpcManager rpcManager0;
    private CountingRpcManager rpcManager1;

    @Override
    protected void createCacheManagers() throws Throwable {
        this.createCluster(TestDataSCI.INSTANCE, FunctionalNoopDoesNotGoToBackupTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC), 2);
        FunctionalMapImpl fmap0 = FunctionalMapImpl.create((AdvancedCache)this.cache(0).getAdvancedCache());
        FunctionalMapImpl fmap1 = FunctionalMapImpl.create((AdvancedCache)this.cache(1).getAdvancedCache());
        this.rw0 = ReadWriteMapImpl.create((FunctionalMapImpl)fmap0);
        this.rw1 = ReadWriteMapImpl.create((FunctionalMapImpl)fmap1);
        this.wo0 = WriteOnlyMapImpl.create((FunctionalMapImpl)fmap0);
        this.wo1 = WriteOnlyMapImpl.create((FunctionalMapImpl)fmap1);
        this.key = new MagicKey(this.cache(0));
        this.rpcManager0 = TestingUtil.wrapComponent(this.cache(0), RpcManager.class, CountingRpcManager::new);
        this.rpcManager1 = TestingUtil.wrapComponent(this.cache(1), RpcManager.class, CountingRpcManager::new);
    }

    @DataProvider(name="ownerAndExistence")
    public Object[][] ownerAndExistence() {
        return new Object[][]{{false, false}, {false, true}, {true, false}, {true, true}};
    }

    @Test(dataProvider="ownerAndExistence")
    public void testReadWriteKeyCommand(boolean onOwner, boolean withExisting) {
        FunctionalMap.ReadWriteMap<Object, Object> rw = onOwner ? this.rw0 : this.rw1;
        this.test(() -> rw.eval((Object)this.key, (SerializableFunction & Serializable)view -> view.find().orElse(null)), onOwner, withExisting);
    }

    @Test(dataProvider="ownerAndExistence")
    public void testReadWriteKeyValueCommand(boolean onOwner, boolean withExisting) {
        FunctionalMap.ReadWriteMap<Object, Object> rw = onOwner ? this.rw0 : this.rw1;
        this.test(() -> rw.eval((Object)this.key, (Object)"bar", (SerializableBiFunction & Serializable)(bar, view) -> view.find().orElse(null)), onOwner, withExisting);
    }

    @Test(dataProvider="ownerAndExistence", enabled=false, description="ISPN-8676")
    public void testReadWriteManyCommand(boolean onOwner, boolean withExisting) {
        FunctionalMap.ReadWriteMap<Object, Object> rw = onOwner ? this.rw0 : this.rw1;
        this.testMany(() -> rw.evalMany(Collections.singleton(this.key), (SerializableFunction & Serializable)view -> view.find().orElse(null)), onOwner, withExisting);
    }

    @Test(dataProvider="ownerAndExistence", enabled=false, description="ISPN-8676")
    public void testReadWriteManyEntriesCommand(boolean onOwner, boolean withExisting) {
        FunctionalMap.ReadWriteMap<Object, Object> rw = onOwner ? this.rw0 : this.rw1;
        this.testMany(() -> rw.evalMany(Collections.singletonMap(this.key, "bar"), (SerializableBiFunction & Serializable)(bar, view) -> view.find().orElse(null)), onOwner, withExisting);
    }

    @Test(dataProvider="ownerAndExistence")
    public void testWriteOnlyKeyCommand(boolean onOwner, boolean withExisting) {
        FunctionalMap.WriteOnlyMap<Object, Object> wo = onOwner ? this.wo0 : this.wo1;
        this.test(() -> wo.eval((Object)this.key, (SerializableConsumer & Serializable)view -> {}), onOwner, withExisting);
    }

    @Test(dataProvider="ownerAndExistence")
    public void testWriteOnlyKeyValueCommand(boolean onOwner, boolean withExisting) {
        FunctionalMap.WriteOnlyMap<Object, Object> wo = onOwner ? this.wo0 : this.wo1;
        this.test(() -> wo.eval((Object)this.key, (Object)"bar", (SerializableBiConsumer & Serializable)(bar, view) -> {}), onOwner, withExisting);
    }

    @Test(dataProvider="ownerAndExistence", enabled=false, description="ISPN-8676")
    public void testWriteOnlyManyCommand(boolean onOwner, boolean withExisting) {
        FunctionalMap.WriteOnlyMap<Object, Object> wo = onOwner ? this.wo0 : this.wo1;
        this.test(() -> wo.evalMany(Collections.singleton(this.key), (SerializableConsumer & Serializable)view -> {}), onOwner, withExisting);
    }

    @Test(dataProvider="ownerAndExistence", enabled=false, description="ISPN-8676")
    public void testWriteOnlyManyEntriesCommand(boolean onOwner, boolean withExisting) {
        FunctionalMap.WriteOnlyMap<Object, Object> wo = onOwner ? this.wo0 : this.wo1;
        this.test(() -> wo.evalMany(Collections.singletonMap(this.key, "bar"), (SerializableBiConsumer & Serializable)(bar, view) -> {}), onOwner, withExisting);
    }

    private void test(Supplier<CompletableFuture<?>> supplier, boolean onOwner, boolean withExisting) {
        if (withExisting) {
            this.cache(0).put((Object)this.key, (Object)"foo");
        }
        this.rpcManager0.otherCount = 0;
        this.rpcManager1.otherCount = 0;
        supplier.get().join();
        AssertJUnit.assertEquals((int)0, (int)this.rpcManager0.otherCount);
        AssertJUnit.assertEquals((int)(onOwner ? 0 : 1), (int)this.rpcManager1.otherCount);
    }

    private void testMany(Supplier<Traversable<?>> supplier, boolean onOwner, boolean withExisting) {
        if (withExisting) {
            this.cache(0).put((Object)this.key, (Object)"foo");
        }
        this.rpcManager0.otherCount = 0;
        this.rpcManager1.otherCount = 0;
        supplier.get().forEach(x -> {});
        AssertJUnit.assertEquals((int)0, (int)this.rpcManager0.otherCount);
        AssertJUnit.assertEquals((int)(onOwner ? 0 : 1), (int)this.rpcManager1.otherCount);
    }
}

