/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.infinispan.Cache;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.functional.AbstractFunctionalOpTest;
import org.infinispan.functional.MetaParam;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.function.SerializableBiConsumer;
import org.infinispan.util.function.SerializableFunction;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="functional.FunctionalCachestoreTest")
public class FunctionalCachestoreTest
extends AbstractFunctionalOpTest {
    @Override
    public Object[] factory() {
        return new Object[]{new FunctionalCachestoreTest().persistence(true).passivation(false), new FunctionalCachestoreTest().persistence(true).passivation(true)};
    }

    @Override
    protected String parameters() {
        return "[passivation=" + this.passivation + "]";
    }

    @Test(dataProvider="owningModeAndWriteMethod")
    public void testWriteLoad(boolean isSourceOwner, AbstractFunctionalOpTest.WriteMethod method) throws Exception {
        Object key = this.getKey(isSourceOwner, "dist");
        List<Cache> owners = this.caches("dist").stream().filter(cache -> cache.getAdvancedCache().getDistributionManager().getCacheTopology().isReadOwner(key)).collect(Collectors.toList());
        method.eval(key, this.wo, this.rw, (SerializableFunction & Serializable)view -> {
            Assert.assertFalse((boolean)view.find().isPresent());
            return null;
        }, (SerializableBiConsumer & Serializable)(view, nil) -> view.set((Object)"value", new MetaParam.Writable[0]), this.getClass());
        this.assertInvocations(2);
        this.caches("dist").forEach(cache -> Assert.assertEquals((Object)cache.get(key), (Object)"value", (String)FunctionalCachestoreTest.getAddress((Cache<Object, Object>)cache).toString()));
        this.advanceGenerationsAndAwait(10L, TimeUnit.SECONDS);
        this.caches("dist").forEach(cache -> cache.evict(key));
        this.caches("dist").forEach(cache -> Assert.assertFalse((boolean)cache.getAdvancedCache().getDataContainer().containsKey(key), (String)FunctionalCachestoreTest.getAddress((Cache<Object, Object>)cache).toString()));
        owners.forEach(cache -> {
            DummyInMemoryStore store = this.getStore((Cache)cache);
            Assert.assertTrue((boolean)store.contains(key), (String)FunctionalCachestoreTest.getAddress((Cache<Object, Object>)cache).toString());
        });
        this.resetInvocationCount();
        method.eval(key, this.wo, this.rw, (SerializableFunction & Serializable)view -> {
            Assert.assertTrue((boolean)view.find().isPresent());
            Assert.assertEquals((String)((String)view.get()), (String)"value");
            return null;
        }, (SerializableBiConsumer & Serializable)(view, nil) -> {}, this.getClass());
        if (method.isMany) {
            this.assertInvocations(2);
        } else {
            this.assertInvocations(1);
        }
    }

    public DummyInMemoryStore getStore(Cache cache) {
        Set stores = TestingUtil.extractComponent(cache, PersistenceManager.class).getStores(DummyInMemoryStore.class);
        return (DummyInMemoryStore)stores.iterator().next();
    }

    @Test(dataProvider="writeMethods")
    public void testWriteLoadLocal(AbstractFunctionalOpTest.WriteMethod method) {
        Integer key = 1;
        method.eval(key, this.lwo, this.lrw, (SerializableFunction & Serializable)view -> {
            Assert.assertFalse((boolean)view.find().isPresent());
            return null;
        }, (SerializableBiConsumer & Serializable)(view, nil) -> view.set((Object)"value", new MetaParam.Writable[0]), this.getClass());
        this.assertInvocations(1);
        Cache cache = ((EmbeddedCacheManager)this.cacheManagers.get(0)).getCache();
        Assert.assertEquals((String)((String)cache.get((Object)key)), (String)"value");
        cache.evict((Object)key);
        Assert.assertFalse((boolean)cache.getAdvancedCache().getDataContainer().containsKey((Object)key));
        DummyInMemoryStore store = this.getStore(cache);
        Assert.assertTrue((boolean)store.contains(key));
        method.eval(key, this.lwo, this.lrw, (SerializableFunction & Serializable)view -> {
            Assert.assertTrue((boolean)view.find().isPresent());
            Assert.assertEquals((String)((String)view.get()), (String)"value");
            return null;
        }, (SerializableBiConsumer & Serializable)(view, nil) -> {}, this.getClass());
        this.assertInvocations(2);
    }

    @Test(dataProvider="owningModeAndReadMethod")
    public void testReadLoad(boolean isSourceOwner, AbstractFunctionalOpTest.ReadMethod method) {
        Object key = this.getKey(isSourceOwner, "dist");
        List<Cache> owners = this.caches("dist").stream().filter(cache -> cache.getAdvancedCache().getDistributionManager().getCacheTopology().isReadOwner(key)).collect(Collectors.toList());
        Assert.assertTrue((boolean)((Boolean)method.eval(key, this.ro, (SerializableFunction & Serializable)view -> {
            Assert.assertFalse((boolean)view.find().isPresent());
            return true;
        })));
        this.cache(0, "dist").put(key, (Object)"value");
        this.caches("dist").forEach(cache -> Assert.assertEquals((Object)cache.get(key), (Object)"value", (String)FunctionalCachestoreTest.getAddress((Cache<Object, Object>)cache).toString()));
        this.caches("dist").forEach(cache -> cache.evict(key));
        this.caches("dist").forEach(cache -> Assert.assertFalse((boolean)cache.getAdvancedCache().getDataContainer().containsKey(key), (String)FunctionalCachestoreTest.getAddress((Cache<Object, Object>)cache).toString()));
        owners.forEach(cache -> {
            Set stores = ((PersistenceManager)ComponentRegistry.componentOf((Cache)cache, PersistenceManager.class)).getStores(DummyInMemoryStore.class);
            DummyInMemoryStore store = (DummyInMemoryStore)stores.iterator().next();
            Assert.assertTrue((boolean)store.contains(key), (String)FunctionalCachestoreTest.getAddress((Cache<Object, Object>)cache).toString());
        });
        Assert.assertEquals((String)((String)method.eval(key, this.ro, (SerializableFunction & Serializable)view -> {
            Assert.assertTrue((boolean)view.find().isPresent());
            Assert.assertEquals((String)((String)view.get()), (String)"value");
            return "OK";
        })), (String)"OK");
    }
}

