/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories.impl;

import java.util.IdentityHashMap;
import java.util.Map;
import org.infinispan.factories.impl.ComponentAccessor;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.factories.impl.WireContext;
import org.infinispan.manager.TestModuleRepository;
import org.infinispan.test.RunningComponentRef;

public final class TestComponentAccessors {
    public static void wire(Object target, Object ... components) {
        TestWireContext wireContext = new TestWireContext(components);
        String accessorName = target.getClass().getName();
        while (accessorName != null) {
            ComponentAccessor componentAccessor = TestModuleRepository.defaultModuleRepository().getComponentAccessor(accessorName);
            componentAccessor.wire(target, (WireContext)wireContext, false);
            accessorName = componentAccessor.getSuperAccessorName();
        }
        IdentityHashMap<Object, Object> unmatchedComponents = new IdentityHashMap<Object, Object>();
        for (Object component : components) {
            if (wireContext.matchedComponents.containsKey(component)) continue;
            unmatchedComponents.put(component, component);
        }
        if (!unmatchedComponents.isEmpty()) {
            throw new IllegalArgumentException("No fields match components " + String.valueOf(unmatchedComponents.values()));
        }
    }

    public static void start(Object target) throws Exception {
        String accessorName = target.getClass().getName();
        while (accessorName != null) {
            ComponentAccessor componentAccessor = TestModuleRepository.defaultModuleRepository().getComponentAccessor(accessorName);
            componentAccessor.start(target);
            accessorName = componentAccessor.getSuperAccessorName();
        }
    }

    public static void stop(Object target) throws Exception {
        String accessorName = target.getClass().getName();
        while (accessorName != null) {
            ComponentAccessor componentAccessor = TestModuleRepository.defaultModuleRepository().getComponentAccessor(accessorName);
            componentAccessor.stop(target);
            accessorName = componentAccessor.getSuperAccessorName();
        }
    }

    static class TestWireContext
    extends WireContext {
        private final Object[] components;
        private final Map<Object, Object> matchedComponents;

        public TestWireContext(Object[] components) {
            super(null);
            this.components = components;
            this.matchedComponents = new IdentityHashMap<Object, Object>(components.length);
        }

        private <T> T findComponent(String componentName, Class<T> componentType) {
            for (Object component : this.components) {
                Object currentMatch = null;
                Object componentInstance = null;
                if (component instanceof NamedComponent) {
                    NamedComponent nc = (NamedComponent)component;
                    if (componentName.equals(nc.name)) {
                        currentMatch = nc;
                        componentInstance = nc.component;
                    }
                } else if (componentType.isInstance(component)) {
                    currentMatch = component;
                    componentInstance = component;
                }
                if (currentMatch == null) continue;
                Object previousMatch = this.matchedComponents.put(currentMatch, currentMatch);
                if (previousMatch != null) {
                    throw new IllegalArgumentException("Ambiguous injection, dependency " + componentName + " is matched by both " + String.valueOf(previousMatch) + " and " + String.valueOf(component));
                }
                return (T)componentInstance;
            }
            return null;
        }

        public <T> T get(String componentName, Class<T> componentClass, boolean start) {
            return this.findComponent(componentName, componentClass);
        }

        public <T, U extends T> ComponentRef<T> getLazy(String componentName, Class<U> componentClass, boolean start) {
            return new RunningComponentRef<U>(componentName, componentClass, this.findComponent(componentName, componentClass));
        }
    }

    public static final class NamedComponent {
        private final String name;
        private final Object component;

        public NamedComponent(String name, Object component) {
            this.name = name;
            this.component = component;
        }

        public String toString() {
            return "NamedComponent{name='" + this.name + "', component=" + String.valueOf(this.component) + "}";
        }
    }
}

