/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories.impl;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.factories.impl.MBeanMetadata;
import org.infinispan.test.RunningComponentRef;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class MockBasicComponentRegistry
implements BasicComponentRegistry {
    private final ConcurrentMap<String, RunningComponentRef> components = new ConcurrentHashMap<String, RunningComponentRef>();

    public void registerMock(String componentName, Class<?> componentType) {
        this.registerComponent(componentName, Mockito.mock(componentType, (Answer)Mockito.RETURNS_DEEP_STUBS), false);
    }

    public void registerMocks(Class<?> ... componentTypes) {
        for (Class<?> componentType : componentTypes) {
            this.registerComponent(componentType, Mockito.mock(componentType, (Answer)Mockito.RETURNS_DEEP_STUBS), false);
        }
    }

    public <T, U extends T> ComponentRef<T> getComponent(String name, Class<U> componentType) {
        return (ComponentRef)this.components.get(name);
    }

    public <T> ComponentRef<T> registerComponent(String componentName, T instance, boolean manageLifecycle) {
        RunningComponentRef<T> componentRef = new RunningComponentRef<T>(componentName, instance.getClass(), instance);
        this.components.put(componentName, componentRef);
        return componentRef;
    }

    public void registerAlias(String aliasName, String targetComponentName, Class<?> targetComponentType) {
        throw new UnsupportedOperationException();
    }

    public void wireDependencies(Object target, boolean startDependencies) {
    }

    public void registerSubComponent(String ownerComponentName, String subComponentName, Object instance) {
        this.registerComponent(subComponentName, instance, false);
    }

    public void addDynamicDependency(String ownerComponentName, String dependencyComponentName) {
    }

    public void replaceComponent(String componentName, Object newInstance, boolean manageLifecycle) {
        throw new UnsupportedOperationException();
    }

    public void rewire() {
        throw new UnsupportedOperationException();
    }

    public Collection<ComponentRef<?>> getRegisteredComponents() {
        throw new UnsupportedOperationException();
    }

    public MBeanMetadata getMBeanMetadata(String className) {
        return null;
    }

    public boolean hasComponentAccessor(String componentClassName) {
        return false;
    }

    public void stop() {
        this.components.clear();
    }

    public <T> ComponentRef<T> lazyGetComponent(Class<T> componentType) {
        return (ComponentRef)this.components.get(componentType.getName());
    }
}

