/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.expiry;

import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionManager;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.Cache;
import org.infinispan.commons.time.ControlledTimeService;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IsolationLevel;
import org.infinispan.expiration.ExpirationManager;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryExpired;
import org.infinispan.notifications.cachelistener.event.CacheEntryExpiredEvent;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="expiry.AutoCommitExpiryTest")
public abstract class AutoCommitExpiryTest
extends SingleCacheManagerTest {
    private final CacheMode mode;
    private final boolean autoCommit;
    protected ControlledTimeService timeService;

    protected AutoCommitExpiryTest(CacheMode mode, boolean autoCommit) {
        this.mode = mode;
        this.autoCommit = autoCommit;
    }

    @Test
    public void testNoAutCommitAndExpiryListener() throws SystemException, NotSupportedException, HeuristicRollbackException, HeuristicMixedException, RollbackException {
        ExpiryListener expiryListener = new ExpiryListener();
        Cache applicationCache = this.cacheManager.getCache();
        applicationCache.addListener((Object)expiryListener);
        TransactionManager tm = applicationCache.getAdvancedCache().getTransactionManager();
        tm.begin();
        applicationCache.put((Object)"test1", (Object)"value1", 1L, TimeUnit.SECONDS);
        tm.commit();
        tm.begin();
        applicationCache.put((Object)"test2", (Object)"value2", 1L, TimeUnit.SECONDS);
        tm.commit();
        this.timeService.advance(TimeUnit.SECONDS.toMillis(10L));
        ExpirationManager manager = applicationCache.getAdvancedCache().getExpirationManager();
        manager.processExpiration();
        AssertJUnit.assertEquals((int)2, (int)expiryListener.getCount());
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        if (this.mode.isClustered()) {
            builder.clustering().cacheMode(this.mode);
        }
        builder.statistics().enable().transaction().transactionMode(TransactionMode.TRANSACTIONAL).transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup()).autoCommit(this.autoCommit).locking().isolationLevel(IsolationLevel.READ_COMMITTED);
        EmbeddedCacheManager cm = TestCacheManagerFactory.createClusteredCacheManager(builder);
        this.timeService = new ControlledTimeService();
        TestingUtil.replaceComponent((CacheContainer)cm, TimeService.class, this.timeService, true);
        return cm;
    }

    @Listener(primaryOnly=true, observation=Listener.Observation.POST)
    public static class ExpiryListener {
        private final AtomicInteger counter = new AtomicInteger();

        public int getCount() {
            return this.counter.get();
        }

        @CacheEntryExpired
        public void expired(CacheEntryExpiredEvent<String, String> event) {
            this.counter.incrementAndGet();
        }
    }
}

