/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.expiration.impl;

import java.util.concurrent.TimeUnit;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.expiration.ExpirationManager;
import org.infinispan.expiration.impl.ExpirationFunctionalTest;
import org.infinispan.expiration.impl.ExpiredCacheListener;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.cachelistener.event.Event;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="expiration.impl.ExpirationListenerFunctionalTest")
public class ExpirationListenerFunctionalTest
extends ExpirationFunctionalTest {
    protected ExpiredCacheListener listener = new ExpiredCacheListener();
    protected ExpirationManager manager;

    @Override
    @Factory
    public Object[] factory() {
        return new Object[]{new ExpirationListenerFunctionalTest().cacheMode(CacheMode.LOCAL).withStorage(StorageType.BINARY), new ExpirationListenerFunctionalTest().cacheMode(CacheMode.LOCAL).withStorage(StorageType.OBJECT), new ExpirationListenerFunctionalTest().cacheMode(CacheMode.LOCAL).withStorage(StorageType.OFF_HEAP), new ExpirationListenerFunctionalTest().cacheMode(CacheMode.DIST_SYNC).withStorage(StorageType.BINARY), new ExpirationListenerFunctionalTest().cacheMode(CacheMode.DIST_SYNC).withStorage(StorageType.OBJECT), new ExpirationListenerFunctionalTest().cacheMode(CacheMode.DIST_SYNC).withStorage(StorageType.OFF_HEAP)};
    }

    @Override
    protected void afterCacheCreated(EmbeddedCacheManager cm) {
        this.cache.addListener((Object)this.listener);
        this.manager = this.cache.getAdvancedCache().getExpirationManager();
    }

    @AfterMethod
    public void resetListener() {
        this.listener.reset();
    }

    @Override
    public void testSimpleExpirationLifespan() throws Exception {
        super.testSimpleExpirationLifespan();
        this.manager.processExpiration();
        this.assertExpiredEvents(10);
    }

    @Override
    public void testSimpleExpirationMaxIdle() throws Exception {
        super.testSimpleExpirationMaxIdle();
        this.manager.processExpiration();
        this.assertExpiredEvents(10);
    }

    private void assertExpiredEvents(int count) {
        AssertJUnit.assertEquals((int)count, (int)this.listener.getInvocationCount());
        this.listener.getEvents().forEach(event -> {
            AssertJUnit.assertEquals((Object)Event.Type.CACHE_ENTRY_EXPIRED, (Object)event.getType());
            AssertJUnit.assertEquals((Object)this.cache, (Object)event.getCache());
            AssertJUnit.assertFalse((boolean)event.isPre());
            AssertJUnit.assertNotNull((Object)event.getKey());
            AssertJUnit.assertNotNull((Object)event.getValue());
            AssertJUnit.assertNotNull((Object)event.getMetadata());
        });
    }

    public void testExpiredEventBetweenCreateEvent() {
        this.cache.put((Object)"foo", (Object)"bar", 1L, TimeUnit.SECONDS);
        this.timeService.advance(2000L);
        this.cache.put((Object)"foo", (Object)"bar2");
        this.assertExpiredEvents(1);
    }
}

