/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.executors;

import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.executors.SemaphoreCompletionService;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.util.concurrent.WithinThreadExecutor;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="executors.SemaphoreCompletionServiceTest")
public class SemaphoreCompletionServiceTest
extends AbstractInfinispanTest {
    private final ExecutorService executor2Threads = Executors.newFixedThreadPool(2, this.getTestThreadFactory("Test"));

    @AfterClass(alwaysRun=true)
    public void stopExecutors() {
        this.executor2Threads.shutdownNow();
    }

    public void testConcurrency1WithinThread() throws Exception {
        SemaphoreCompletionService completionService = new SemaphoreCompletionService((Executor)new WithinThreadExecutor(), 1);
        Future future1 = completionService.submit((Callable)new DummyTask());
        Future future2 = completionService.poll();
        AssertJUnit.assertSame((Object)future1, (Object)future2);
        AssertJUnit.assertNotNull((Object)future2);
        AssertJUnit.assertEquals((String)"bla", (String)((String)future2.get()));
    }

    public void testConcurrencyLimit() throws Exception {
        SemaphoreCompletionService completionService = new SemaphoreCompletionService((Executor)this.executor2Threads, 1);
        CountDownLatch latch = new CountDownLatch(1);
        Future blockingFuture = completionService.submit((Callable)new BlockingTask(latch));
        Future dummyFuture = completionService.submit((Callable)new DummyTask());
        AssertJUnit.assertNull((Object)completionService.poll(1L, TimeUnit.SECONDS));
        AssertJUnit.assertFalse((boolean)dummyFuture.isDone());
        latch.countDown();
        AssertJUnit.assertEquals((String)"bla", (String)((String)blockingFuture.get(10L, TimeUnit.SECONDS)));
        AssertJUnit.assertEquals((String)"bla", (String)((String)dummyFuture.get(10L, TimeUnit.SECONDS)));
    }

    public void testBackgroundTasks() throws Exception {
        SemaphoreCompletionService completionService = new SemaphoreCompletionService((Executor)this.executor2Threads, 1);
        CountDownLatch latch = new CountDownLatch(1);
        Future backgroundInitFuture = completionService.submit((Callable)new BackgroundInitTask((SemaphoreCompletionService<String>)completionService));
        AssertJUnit.assertEquals((String)"bla", (String)((String)backgroundInitFuture.get(1L, TimeUnit.SECONDS)));
        Future dummyFuture = completionService.submit((Callable)new DummyTask());
        AssertJUnit.assertSame((Object)backgroundInitFuture, (Object)completionService.poll(1L, TimeUnit.SECONDS));
        AssertJUnit.assertFalse((boolean)dummyFuture.isDone());
        Future backgroundEndFuture = completionService.backgroundTaskFinished((Callable)new BlockingTask(latch));
        AssertJUnit.assertNull((Object)completionService.poll(1L, TimeUnit.SECONDS));
        AssertJUnit.assertFalse((boolean)dummyFuture.isDone());
        latch.countDown();
        AssertJUnit.assertEquals((String)"bla", (String)((String)backgroundEndFuture.get(10L, TimeUnit.SECONDS)));
        AssertJUnit.assertEquals((String)"bla", (String)((String)dummyFuture.get(10L, TimeUnit.SECONDS)));
    }

    private static class DummyTask
    implements Callable<String> {
        private DummyTask() {
        }

        @Override
        public String call() throws Exception {
            return "bla";
        }
    }

    private static class BlockingTask
    implements Callable<String> {
        private final CountDownLatch latch;

        private BlockingTask(CountDownLatch latch) {
            this.latch = latch;
        }

        @Override
        public String call() throws Exception {
            this.latch.await(30L, TimeUnit.SECONDS);
            return "bla";
        }
    }

    private static class BackgroundInitTask
    implements Callable<String> {
        private final SemaphoreCompletionService<String> completionService;

        private BackgroundInitTask(SemaphoreCompletionService<String> completionService) {
            this.completionService = completionService;
        }

        @Override
        public String call() throws Exception {
            this.completionService.continueTaskInBackground();
            return "bla";
        }
    }
}

