/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.executors;

import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.util.concurrent.BlockingRunnable;
import org.infinispan.util.concurrent.BlockingTaskAwareExecutorServiceImpl;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="executors.BlockingTaskAwareExecutorServiceTest")
public class BlockingTaskAwareExecutorServiceTest
extends AbstractInfinispanTest {
    private static final AtomicInteger THREAD_ID = new AtomicInteger(0);

    public void testSimpleExecution() throws Exception {
        BlockingTaskAwareExecutorServiceImpl executorService = this.createExecutorService();
        try {
            DoSomething doSomething = new DoSomething();
            executorService.execute((BlockingRunnable)doSomething);
            Thread.sleep(100L);
            assert (!doSomething.isReady());
            assert (!doSomething.isExecuted());
            doSomething.markReady();
            executorService.checkForReadyTasks();
            assert (doSomething.isReady());
            BlockingTaskAwareExecutorServiceTest.eventually(doSomething::isExecuted);
        }
        finally {
            executorService.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultipleExecutions() throws Exception {
        BlockingTaskAwareExecutorServiceImpl executorService = this.createExecutorService();
        try {
            LinkedList<DoSomething> tasks = new LinkedList<DoSomething>();
            for (int i = 0; i < 30; ++i) {
                tasks.add(new DoSomething());
            }
            tasks.forEach(arg_0 -> ((BlockingTaskAwareExecutorServiceImpl)executorService).execute(arg_0));
            for (DoSomething doSomething : tasks) {
                assert (!doSomething.isReady());
                assert (!doSomething.isExecuted());
            }
            tasks.forEach(DoSomething::markReady);
            executorService.checkForReadyTasks();
            for (DoSomething doSomething : tasks) {
                BlockingTaskAwareExecutorServiceTest.eventually(doSomething::isExecuted);
            }
        }
        finally {
            executorService.shutdownNow();
        }
    }

    private BlockingTaskAwareExecutorServiceImpl createExecutorService() {
        ThreadPoolExecutor realOne = new ThreadPoolExecutor(1, 2, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new DummyThreadFactory());
        return new BlockingTaskAwareExecutorServiceImpl((ExecutorService)realOne, TIME_SERVICE);
    }

    public static class DoSomething
    implements BlockingRunnable {
        private volatile boolean ready = false;
        private volatile boolean executed = false;

        public final synchronized boolean isReady() {
            return this.ready;
        }

        public final synchronized void run() {
            this.executed = true;
        }

        public final synchronized void markReady() {
            this.ready = true;
        }

        public final synchronized boolean isExecuted() {
            return this.executed;
        }
    }

    public static class DummyThreadFactory
    implements ThreadFactory {
        @Override
        public Thread newThread(Runnable runnable) {
            return new Thread(runnable, "Remote-" + this.getClass().getSimpleName() + "-" + THREAD_ID.incrementAndGet());
        }
    }
}

