/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.eviction.impl;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.eviction.EvictionType;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.MessageMarshaller;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.jgroups.util.Util;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="eviction.MarshalledValuesEvictionTest")
public class MarshalledValuesEvictionTest
extends SingleCacheManagerTest {
    private static final int CACHE_SIZE = 128;

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = new ConfigurationBuilder();
        cfg.memory().size(128L).evictionType(EvictionType.COUNT).storageType(StorageType.BINARY).expiration().wakeUpInterval(100L).locking().useLockStriping(false).build();
        this.cacheManager = TestCacheManagerFactory.createCacheManager(new ContextInitializer(), cfg);
        this.cache = this.cacheManager.getCache();
        return this.cacheManager;
    }

    public void testEvictCustomKeyValue() {
        EvictionPojoMarshaller.resetStats();
        int expectedWrites = 0;
        int expectedReads = 0;
        for (int i = 0; i < 256; ++i) {
            EvictionPojo p1 = new EvictionPojo();
            p1.i = (int)Util.random((long)2000L);
            EvictionPojo p2 = new EvictionPojo();
            p2.i = 24;
            Object old = this.cache.put((Object)p1, (Object)p2);
            if (old != null) {
                ++expectedReads;
            }
            expectedWrites += 2;
        }
        AssertJUnit.assertEquals((int)128, (int)this.cache.getAdvancedCache().getDataContainer().size());
        AssertJUnit.assertEquals((int)expectedWrites, (int)EvictionPojoMarshaller.writes.get());
        AssertJUnit.assertEquals((int)expectedReads, (int)EvictionPojoMarshaller.reads.get());
    }

    public void testEvictPrimitiveKeyCustomValue() {
        EvictionPojoMarshaller.resetStats();
        int expectedWrites = 0;
        int expectedReads = 0;
        for (int i = 0; i < 256; ++i) {
            EvictionPojo p1 = new EvictionPojo();
            p1.i = (int)Util.random((long)2000L);
            Object old = this.cache.put((Object)i, (Object)p1);
            if (old != null) {
                ++expectedReads;
            }
            ++expectedWrites;
        }
        AssertJUnit.assertEquals((int)expectedWrites, (int)EvictionPojoMarshaller.writes.get());
        AssertJUnit.assertEquals((int)expectedReads, (int)EvictionPojoMarshaller.reads.get());
    }

    private static class ContextInitializer
    implements SerializationContextInitializer {
        private ContextInitializer() {
        }

        public String getProtoFileName() {
            return EvictionPojo.class.getName();
        }

        public String getProtoFile() throws UncheckedIOException {
            return "message EvictionPojo {optional int32 i=1;}";
        }

        public void registerSchema(SerializationContext serCtx) {
            serCtx.registerProtoFiles(FileDescriptorSource.fromString((String)this.getProtoFileName(), (String)this.getProtoFile()));
        }

        public void registerMarshallers(SerializationContext serCtx) {
            serCtx.registerMarshaller((BaseMarshaller)new EvictionPojoMarshaller());
        }
    }

    static class EvictionPojoMarshaller
    implements MessageMarshaller<EvictionPojo> {
        static AtomicInteger writes = new AtomicInteger();
        static AtomicInteger reads = new AtomicInteger();

        EvictionPojoMarshaller() {
        }

        public static void resetStats() {
            reads.set(0);
            writes.set(0);
        }

        public EvictionPojo readFrom(MessageMarshaller.ProtoStreamReader reader) throws IOException {
            EvictionPojo o = new EvictionPojo();
            o.i = reader.readInt("i");
            reads.incrementAndGet();
            return o;
        }

        public void writeTo(MessageMarshaller.ProtoStreamWriter writer, EvictionPojo evictionPojo) throws IOException {
            writer.writeInt("i", evictionPojo.i);
            writes.incrementAndGet();
        }

        public Class<? extends EvictionPojo> getJavaClass() {
            return EvictionPojo.class;
        }

        public String getTypeName() {
            return "EvictionPojo";
        }
    }

    public static class EvictionPojo {
        @ProtoField(number=1, defaultValue="0")
        int i;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EvictionPojo pojo = (EvictionPojo)o;
            return this.i == pojo.i;
        }

        public int hashCode() {
            int result = this.i;
            return result;
        }
    }
}

