/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.groups;

import io.reactivex.rxjava3.core.Flowable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.context.Flag;
import org.infinispan.distribution.groups.BaseUtilGroupTest;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.test.TestingUtil;
import org.reactivestreams.Publisher;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.groups.GetGroupKeysTest")
public class GetGroupKeysTest
extends BaseUtilGroupTest {
    protected static final String PERSISTENCE_CACHE = "persistence-cache";
    protected static final String PERSISTENCE_PASSIVATION_CACHE = "persistence-passivation-cache";
    protected final boolean transactional;

    @Override
    public Object[] factory() {
        return new Object[]{new GetGroupKeysTest(false, BaseUtilGroupTest.TestCacheFactory.PRIMARY_OWNER), new GetGroupKeysTest(false, BaseUtilGroupTest.TestCacheFactory.BACKUP_OWNER), new GetGroupKeysTest(false, BaseUtilGroupTest.TestCacheFactory.NON_OWNER)};
    }

    public GetGroupKeysTest() {
        this(false, null);
    }

    protected GetGroupKeysTest(boolean transactional, BaseUtilGroupTest.TestCacheFactory factory) {
        super(factory);
        this.transactional = transactional;
    }

    public void testGetKeysInGroup() {
        BaseUtilGroupTest.TestCache testCache = this.createTestCacheAndReset("test-group", this.caches());
        GetGroupKeysTest.initCache(testCache.primaryOwner);
        Map groupKeySet = testCache.testCache.getGroup("test-group");
        Map<BaseUtilGroupTest.GroupKey, String> expectedGroupSet = GetGroupKeysTest.createMap(0, 10);
        AssertJUnit.assertEquals(expectedGroupSet, (Object)groupKeySet);
    }

    public void testGetKeysInGroupWithPersistence() {
        BaseUtilGroupTest.TestCache testCache = this.createTestCacheAndReset("test-group", this.caches(PERSISTENCE_CACHE));
        GetGroupKeysTest.initCache(testCache.primaryOwner);
        Map groupKeySet = testCache.testCache.getGroup("test-group");
        Map<BaseUtilGroupTest.GroupKey, String> expectedGroupSet = GetGroupKeysTest.createMap(0, 10);
        AssertJUnit.assertEquals(expectedGroupSet, (Object)groupKeySet);
    }

    public void testGetKeysInGroupWithPersistenceAndPassivation() {
        BaseUtilGroupTest.TestCache testCache = this.createTestCacheAndReset("test-group", this.caches(PERSISTENCE_PASSIVATION_CACHE));
        GetGroupKeysTest.initCache(testCache.primaryOwner);
        Map groupKeySet = testCache.testCache.getGroup("test-group");
        Map<BaseUtilGroupTest.GroupKey, String> expectedGroupSet = GetGroupKeysTest.createMap(0, 10);
        AssertJUnit.assertEquals(expectedGroupSet, (Object)groupKeySet);
    }

    public void testGetKeysInGroupWithPersistenceAndSkipCacheLoader() {
        BaseUtilGroupTest.TestCache testCache = this.createTestCacheAndReset("test-group", this.caches(PERSISTENCE_CACHE));
        GetGroupKeysTest.initCache(testCache.primaryOwner);
        Map groupKeySet = testCache.testCache.withFlags(Flag.SKIP_CACHE_LOAD).getGroup("test-group");
        HashMap<BaseUtilGroupTest.GroupKey, String> expectedGroupSet = new HashMap<BaseUtilGroupTest.GroupKey, String>();
        for (InternalCacheEntry entry : (DataContainer)TestingUtil.extractComponent(GetGroupKeysTest.extractTargetCache(testCache), InternalDataContainer.class)) {
            if (!((BaseUtilGroupTest.GroupKey)entry.getKey()).getGroup().equals("test-group")) continue;
            expectedGroupSet.put((BaseUtilGroupTest.GroupKey)entry.getKey(), (String)entry.getValue());
        }
        AssertJUnit.assertEquals(expectedGroupSet, (Object)groupKeySet);
    }

    public void testRemoveGroupKeys() {
        BaseUtilGroupTest.TestCache testCache = this.createTestCacheAndReset("test-group", this.caches());
        GetGroupKeysTest.initCache(testCache.primaryOwner);
        Map groupKeySet = testCache.testCache.getGroup("test-group");
        Map<BaseUtilGroupTest.GroupKey, String> expectedGroupSet = GetGroupKeysTest.createMap(0, 10);
        AssertJUnit.assertEquals(expectedGroupSet, (Object)groupKeySet);
        testCache.testCache.removeGroup("test-group");
        AssertJUnit.assertEquals(Collections.emptyMap(), (Object)testCache.testCache.getGroup("test-group"));
    }

    public void testRemoveGroupKeysWithPersistence() {
        BaseUtilGroupTest.TestCache testCache = this.createTestCacheAndReset("test-group", this.caches(PERSISTENCE_CACHE));
        GetGroupKeysTest.initCache(testCache.primaryOwner);
        Map groupKeySet = testCache.testCache.getGroup("test-group");
        Map<BaseUtilGroupTest.GroupKey, String> expectedGroupSet = GetGroupKeysTest.createMap(0, 10);
        AssertJUnit.assertEquals(expectedGroupSet, (Object)groupKeySet);
        testCache.testCache.removeGroup("test-group");
        AssertJUnit.assertEquals(Collections.emptyMap(), (Object)testCache.testCache.getGroup("test-group"));
    }

    public void testRemoveGroupKeysWithPersistenceAndPassivation() {
        BaseUtilGroupTest.TestCache testCache = this.createTestCacheAndReset("test-group", this.caches(PERSISTENCE_PASSIVATION_CACHE));
        GetGroupKeysTest.initCache(testCache.primaryOwner);
        Map groupKeySet = testCache.testCache.getGroup("test-group");
        Map<BaseUtilGroupTest.GroupKey, String> expectedGroupSet = GetGroupKeysTest.createMap(0, 10);
        AssertJUnit.assertEquals(expectedGroupSet, (Object)groupKeySet);
        testCache.testCache.removeGroup("test-group");
        AssertJUnit.assertEquals(Collections.emptyMap(), (Object)testCache.testCache.getGroup("test-group"));
    }

    public void testRemoveGroupKeysWithPersistenceAndSkipCacheWriter() {
        BaseUtilGroupTest.TestCache testCache = this.createTestCacheAndReset("test-group", this.caches(PERSISTENCE_CACHE));
        GetGroupKeysTest.initCache(testCache.primaryOwner);
        Map groupKeySet = testCache.testCache.getGroup("test-group");
        Map<BaseUtilGroupTest.GroupKey, String> expectedGroupSet = GetGroupKeysTest.createMap(0, 10);
        AssertJUnit.assertEquals(expectedGroupSet, (Object)groupKeySet);
        testCache.testCache.withFlags(Flag.SKIP_CACHE_STORE).removeGroup("test-group");
        ConcurrentHashMap expectedGroupSet2 = new ConcurrentHashMap();
        Flowable flowable = Flowable.fromPublisher((Publisher)TestingUtil.extractComponent(GetGroupKeysTest.extractTargetCache(testCache), PersistenceManager.class).publishEntries(true, true));
        flowable.filter(me -> "test-group".equals(((BaseUtilGroupTest.GroupKey)me.getKey()).getGroup())).blockingForEach(me -> expectedGroupSet2.put((BaseUtilGroupTest.GroupKey)me.getKey(), (String)me.getValue()));
        AssertJUnit.assertEquals(new HashMap(expectedGroupSet2), (Object)testCache.testCache.getGroup("test-group"));
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        this.createClusteredCaches(3, BaseUtilGroupTest.GroupTestsSCI.INSTANCE, this.amendConfiguration(this.createConfigurationBuilder(this.transactional)));
        this.defineConfigurationOnAllManagers(PERSISTENCE_CACHE, this.amendConfiguration(this.createConfigurationBuilderWithPersistence(this.transactional, false)));
        this.waitForClusterToForm(PERSISTENCE_CACHE);
        this.defineConfigurationOnAllManagers(PERSISTENCE_PASSIVATION_CACHE, this.amendConfiguration(this.createConfigurationBuilderWithPersistence(this.transactional, true)));
        this.waitForClusterToForm(PERSISTENCE_PASSIVATION_CACHE);
    }

    protected ConfigurationBuilder amendConfiguration(ConfigurationBuilder builder) {
        return builder;
    }

    @Override
    protected final void resetCaches(List<Cache<BaseUtilGroupTest.GroupKey, String>> cacheList) {
    }

    private ConfigurationBuilder createConfigurationBuilder(boolean transactional) {
        ConfigurationBuilder builder = GetGroupKeysTest.getDefaultClusteredCacheConfig(this.cacheMode, transactional);
        builder.clustering().stateTransfer().fetchInMemoryState(false);
        builder.clustering().hash().groups().enabled(true);
        return builder;
    }

    private ConfigurationBuilder createConfigurationBuilderWithPersistence(boolean transactional, boolean passivation) {
        ConfigurationBuilder builder = this.createConfigurationBuilder(transactional);
        if (passivation) {
            builder.memory().maxCount(2L);
        }
        builder.persistence().passivation(passivation).addStore(DummyInMemoryStoreConfigurationBuilder.class);
        return builder;
    }
}

