/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.List;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.MultipleNodesLeavingTest")
public class MultipleNodesLeavingTest
extends MultipleCacheManagersTest {
    @Override
    public Object[] factory() {
        return new Object[]{new MultipleNodesLeavingTest().cacheMode(CacheMode.DIST_SYNC)};
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = MultipleNodesLeavingTest.getDefaultClusteredCacheConfig(this.cacheMode, false);
        this.createCluster(builder, 4);
        this.waitForClusterToForm();
    }

    public void testMultipleLeaves() throws Exception {
        this.fork(() -> this.manager(3).stop());
        this.fork(() -> this.manager(2).stop());
        this.fork(() -> this.manager(1).stop());
        this.eventuallyEquals(1, () -> this.advancedCache(0).getRpcManager().getTransport().getMembers().size());
        log.trace((Object)"MultipleNodesLeavingTest.testMultipleLeaves");
        TestingUtil.blockUntilViewsReceived(60000L, false, this.cache(0));
        TestingUtil.waitForNoRebalance(this.cache(0));
        List caches = this.advancedCache(0).getDistributionManager().getWriteConsistentHash().getMembers();
        log.tracef("caches = %s", (Object)caches);
        int size = caches.size();
        assert (size == 1);
    }
}

