/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.infinispan.distribution.DistributionTestHelper;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.remoting.transport.Address;

public class MagicKey
implements Serializable {
    private static final WeakHashMap<Integer, int[]> hashCodes = new WeakHashMap();
    private static final AtomicLong counter = new AtomicLong();
    @ProtoField(value=1)
    final String name;
    @ProtoField(number=2, defaultValue="0")
    final int hashcode;
    @ProtoField(number=3, defaultValue="0")
    final long unique;
    @ProtoField(number=4, defaultValue="0")
    final int segment;
    @ProtoField(value=5)
    final String address;

    @ProtoFactory
    MagicKey(String name, int hashcode, long unique, int segment, String address) {
        this.name = name;
        this.hashcode = hashcode;
        this.unique = unique;
        this.segment = segment;
        this.address = address;
    }

    public MagicKey(String name, Cache<?, ?> primaryOwner) {
        this.name = name;
        Address primaryAddress = DistributionTestHelper.addressOf(primaryOwner);
        this.address = primaryAddress.toString();
        LocalizedCacheTopology cacheTopology = primaryOwner.getAdvancedCache().getDistributionManager().getCacheTopology();
        ConsistentHash ch = cacheTopology.getWriteConsistentHash();
        int segment = this.findSegment(ch.getNumSegments(), s -> primaryAddress.equals((Object)ch.locatePrimaryOwnerForSegment(s.intValue())));
        if (segment < 0) {
            throw new IllegalStateException("Could not find any segment owned by " + String.valueOf(primaryOwner) + ", primary segments: " + String.valueOf(this.segments(primaryOwner)));
        }
        this.segment = segment;
        this.hashcode = MagicKey.getHashCodeForSegment(cacheTopology, segment);
        this.unique = counter.getAndIncrement();
    }

    public MagicKey(String name, Cache<?, ?> primaryOwner, Cache<?, ?> ... backupOwners) {
        this.name = name;
        Address primaryAddress = DistributionTestHelper.addressOf(primaryOwner);
        this.address = primaryAddress.toString();
        LocalizedCacheTopology cacheTopology = primaryOwner.getAdvancedCache().getDistributionManager().getCacheTopology();
        ConsistentHash ch = cacheTopology.getWriteConsistentHash();
        this.segment = this.findSegment(ch.getNumSegments(), s -> {
            List owners = ch.locateOwnersForSegment(s.intValue());
            if (!primaryAddress.equals(owners.get(0))) {
                return false;
            }
            for (Cache backup : backupOwners) {
                if (owners.contains(DistributionTestHelper.addressOf(backup))) continue;
                return false;
            }
            return true;
        });
        if (this.segment < 0) {
            throw new IllegalStateException("Could not find any segment owned by " + String.valueOf(primaryOwner) + ", " + Arrays.toString(backupOwners) + ", primary segments: " + String.valueOf(this.segments(primaryOwner)) + ", backup segments: " + String.valueOf(Stream.of(backupOwners).collect(Collectors.toMap(Function.identity(), this::segments))));
        }
        this.hashcode = MagicKey.getHashCodeForSegment(cacheTopology, this.segment);
        this.unique = counter.getAndIncrement();
    }

    private int findSegment(int numSegments, Predicate<Integer> predicate) {
        int offset = ThreadLocalRandom.current().nextInt(numSegments);
        for (int i = 0; i < numSegments; ++i) {
            int segment = (offset + i) % numSegments;
            if (!predicate.test(segment)) continue;
            return segment;
        }
        return -1;
    }

    private static synchronized int getHashCodeForSegment(LocalizedCacheTopology cacheTopology, int segment) {
        int dummy;
        int numSegments = cacheTopology.getReadConsistentHash().getNumSegments();
        int[] hcs = hashCodes.computeIfAbsent(numSegments, k -> new int[numSegments]);
        int hc = hcs[segment];
        if (hc != 0) {
            return hc;
        }
        Random r = new Random();
        int attemptsLeft = 100 * numSegments;
        do {
            dummy = r.nextInt();
            if (--attemptsLeft >= 0) continue;
            throw new IllegalStateException("Could not find any key in segment " + segment);
        } while (cacheTopology.getSegment((Object)dummy) != segment);
        hcs[segment] = dummy;
        return hcs[segment];
    }

    private Set<Integer> segments(Cache<?, ?> owner) {
        return owner.getAdvancedCache().getDistributionManager().getWriteConsistentHash().getPrimarySegmentsForOwner(owner.getCacheManager().getAddress());
    }

    public MagicKey(Cache<?, ?> primaryOwner) {
        this((String)null, primaryOwner);
    }

    public MagicKey(Cache<?, ?> primaryOwner, Cache<?, ?> ... backupOwners) {
        this((String)null, primaryOwner, backupOwners);
    }

    public int hashCode() {
        return this.hashcode;
    }

    public int getSegment() {
        return this.segment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MagicKey magicKey = (MagicKey)o;
        return this.hashcode == magicKey.hashcode && this.address.equals(magicKey.address) && Objects.equals(this.name, magicKey.name) && this.unique == magicKey.unique;
    }

    public String toString() {
        return String.format("MagicKey%s{%X/%08X/%d@%s}", this.name == null ? "" : "#" + this.name, this.unique, this.hashcode, this.segment, this.address);
    }
}

