/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.versioning;

import java.util.Arrays;
import java.util.List;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.container.versioning.NumericVersionGenerator;
import org.infinispan.container.versioning.RankCalculator;
import org.infinispan.notifications.cachemanagerlistener.event.Event;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.notifications.cachemanagerlistener.event.impl.EventImpl;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="container.versioning.NumericVersionGeneratorTest")
public class NumericVersionGeneratorTest {
    public void testGenerateVersion() {
        RankCalculator rankCalculator = new RankCalculator();
        Configuration config = new ConfigurationBuilder().clustering().cacheMode(CacheMode.DIST_SYNC).build();
        NumericVersionGenerator vg = new NumericVersionGenerator();
        TestingUtil.inject(vg, rankCalculator, config);
        vg.start();
        vg.resetCounter();
        TestAddress addr1 = new TestAddress(1);
        TestAddress addr2 = new TestAddress(2);
        TestAddress addr3 = new TestAddress(1);
        List<Address> members = Arrays.asList(addr1, addr2, addr3);
        rankCalculator.updateRank((ViewChangedEvent)new EventImpl(null, null, Event.Type.VIEW_CHANGED, members, members, (Address)addr2, 1));
        AssertJUnit.assertEquals((long)0x1000200000000L, (long)rankCalculator.getVersionPrefix());
        AssertJUnit.assertEquals((Object)new NumericVersion(0x1000200000001L), (Object)vg.generateNew());
        AssertJUnit.assertEquals((Object)new NumericVersion(0x1000200000002L), (Object)vg.generateNew());
        members = Arrays.asList(addr2, addr3);
        rankCalculator.updateRank((ViewChangedEvent)new EventImpl(null, null, Event.Type.VIEW_CHANGED, members, members, (Address)addr2, 2));
        AssertJUnit.assertEquals((long)0x2000100000000L, (long)rankCalculator.getVersionPrefix());
        AssertJUnit.assertEquals((Object)new NumericVersion(562954248388611L), (Object)vg.generateNew());
    }

    static class TestAddress
    implements Address {
        int addressNum;

        TestAddress(int addressNum) {
            this.addressNum = addressNum;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            TestAddress that = (TestAddress)o;
            return this.addressNum == that.addressNum;
        }

        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.addressNum;
            return result;
        }

        public int compareTo(Address o) {
            TestAddress oa = (TestAddress)o;
            return this.addressNum - oa.addressNum;
        }
    }
}

