/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.versioning;

import jakarta.transaction.RollbackException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IsolationLevel;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.LockingMode;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="container.versioning.LocalWriteSkewTest", groups={"functional"})
@CleanupAfterMethod
public class LocalWriteSkewTest
extends SingleCacheManagerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration(true);
        builder.locking().isolationLevel(IsolationLevel.REPEATABLE_READ).transaction().lockingMode(LockingMode.OPTIMISTIC);
        return TestCacheManagerFactory.createCacheManager(builder);
    }

    public void testWriteSkewEnabled() throws Exception {
        this.cache.put((Object)"hello", (Object)"world 1");
        this.tm().begin();
        AssertJUnit.assertEquals((String)"Wrong value read by transaction for key hello", (Object)"world 1", (Object)this.cache.get((Object)"hello"));
        Transaction t = this.tm().suspend();
        this.cache.put((Object)"hello", (Object)"world 3");
        this.tm().resume(t);
        this.cache.put((Object)"hello", (Object)"world 2");
        Exceptions.expectException(RollbackException.class, () -> ((TransactionManager)this.tm()).commit());
        AssertJUnit.assertEquals((String)"Wrong final value for key hello", (Object)"world 3", (Object)this.cache.get((Object)"hello"));
    }

    public void testWriteSkewMultiEntries() throws Exception {
        this.tm().begin();
        this.cache.put((Object)"k1", (Object)"v1");
        this.cache.put((Object)"k2", (Object)"v2");
        this.tm().commit();
        this.tm().begin();
        this.cache.put((Object)"k2", (Object)"v2000");
        AssertJUnit.assertEquals((String)"Wrong value read by transaction for key k1", (Object)"v1", (Object)this.cache.get((Object)"k1"));
        AssertJUnit.assertEquals((String)"Wrong value read by transaction for key k2", (Object)"v2000", (Object)this.cache.get((Object)"k2"));
        Transaction t = this.tm().suspend();
        this.cache.put((Object)"k1", (Object)"v3");
        this.tm().resume(t);
        this.cache.put((Object)"k1", (Object)"v5000");
        Exceptions.expectException(RollbackException.class, () -> ((TransactionManager)this.tm()).commit());
        AssertJUnit.assertEquals((String)"Wrong final value for key k1", (Object)"v3", (Object)this.cache.get((Object)"k1"));
        AssertJUnit.assertEquals((String)"Wrong final value for key k2", (Object)"v2", (Object)this.cache.get((Object)"k2"));
    }

    public void testNullEntries() throws Exception {
        this.cache.put((Object)"hello", (Object)"world");
        this.tm().begin();
        AssertJUnit.assertEquals((String)"Wrong value read by transaction for key hello", (Object)"world", (Object)this.cache.get((Object)"hello"));
        Transaction t = this.tm().suspend();
        this.cache.remove((Object)"hello");
        AssertJUnit.assertEquals((String)"Wrong value after remove for key hello", null, (Object)this.cache.get((Object)"hello"));
        this.tm().resume(t);
        this.cache.put((Object)"hello", (Object)"world2");
        Exceptions.expectException(RollbackException.class, () -> ((TransactionManager)this.tm()).commit());
        AssertJUnit.assertEquals((String)"Wrong final value for key hello", null, (Object)this.cache.get((Object)"hello"));
    }

    public void testSameNodeKeyCreation() throws Exception {
        this.tm().begin();
        AssertJUnit.assertEquals((String)"Wrong value read by transaction 1 for key NewKey", null, (Object)this.cache.get((Object)"NewKey"));
        this.cache.put((Object)"NewKey", (Object)"v1");
        Transaction tx0 = this.tm().suspend();
        this.tm().begin();
        AssertJUnit.assertEquals((String)"Wrong value read by transaction 2 for key NewKey", null, (Object)this.cache.get((Object)"NewKey"));
        this.cache.put((Object)"NewKey", (Object)"v2");
        this.tm().commit();
        this.tm().resume(tx0);
        Exceptions.expectException(RollbackException.class, () -> ((TransactionManager)this.tm()).commit());
        AssertJUnit.assertEquals((String)"Wrong final value for key NewKey", (Object)"v2", (Object)this.cache.get((Object)"NewKey"));
    }
}

