/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.parsing;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="configuration.JsonParsingTest")
public class JsonParsingTest
extends AbstractInfinispanTest {
    public void testSerializationAllowList() throws IOException {
        ParserRegistry parserRegistry = new ParserRegistry(Thread.currentThread().getContextClassLoader(), true, System.getProperties());
        ConfigurationBuilderHolder holder = parserRegistry.parseFile("configs/serialization-test.json");
        GlobalConfiguration globalConfiguration = holder.getGlobalConfigurationBuilder().build();
        Set classes = globalConfiguration.serialization().allowList().getClasses();
        AssertJUnit.assertEquals((int)3, (int)classes.size());
        List regexps = globalConfiguration.serialization().allowList().getRegexps();
        AssertJUnit.assertEquals((int)2, (int)regexps.size());
    }

    public void testErrorReporting() {
        ParserRegistry parserRegistry = new ParserRegistry(Thread.currentThread().getContextClassLoader(), true, System.getProperties());
        Exceptions.expectException((String)"^ISPN000327:.*broken.json\\[23,15\\].*", () -> parserRegistry.parseFile("configs/broken.json"), (Class[])new Class[]{CacheConfigurationException.class});
    }

    public void testInvalidTracingCollector() throws Exception {
        ParserRegistry parserRegistry = new ParserRegistry(Thread.currentThread().getContextClassLoader(), true, System.getProperties());
        ConfigurationBuilderHolder holder = parserRegistry.parseFile("configs/tracing-endpoint-wrong.json");
        Exceptions.expectException((String)"^ISPN000972:.*Tracing collector endpoint 'sdjsd92k2..21232' is not valid.*", () -> holder.getGlobalConfigurationBuilder().build(), (Class[])new Class[]{CacheConfigurationException.class});
    }

    public void testAliasTest() throws IOException {
        ParserRegistry parserRegistry = new ParserRegistry(Thread.currentThread().getContextClassLoader(), true, System.getProperties());
        ConfigurationBuilderHolder holder = parserRegistry.parseFile("configs/aliases-test.json");
        Configuration cache = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("another-resp-cache")).build();
        AssertJUnit.assertEquals(List.of("1"), (Object)cache.aliases());
    }
}

