/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration;

import jakarta.transaction.TransactionManager;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.tm.EmbeddedBaseTransactionManager;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="configuration.TxManagerLookupConfigTest")
public class TxManagerLookupConfigTest
extends AbstractInfinispanTest {
    static TmA tma = new TmA();
    static TmB tmb = new TmB();

    public void simpleTest() {
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createCacheManager()){

            @Override
            public void call() {
                ConfigurationBuilder customConfiguration = TestCacheManagerFactory.getDefaultCacheConfiguration(true);
                customConfiguration.transaction().transactionManagerLookup((TransactionManagerLookup)new TxManagerLookupA());
                Configuration definedConfiguration = this.cm.defineConfiguration("aCache", customConfiguration.build());
                AssertJUnit.assertTrue((boolean)(definedConfiguration.transaction().transactionManagerLookup() instanceof TxManagerLookupA));
                TransactionManager activeTransactionManager = this.cm.getCache("aCache").getAdvancedCache().getTransactionManager();
                AssertJUnit.assertNotNull((Object)activeTransactionManager);
                AssertJUnit.assertTrue((boolean)(activeTransactionManager instanceof TmA));
            }
        });
    }

    private static class TmA
    extends EmbeddedBaseTransactionManager {
        private TmA() {
        }
    }

    private static class TmB
    extends EmbeddedBaseTransactionManager {
        private TmB() {
        }
    }

    public static class TxManagerLookupB
    implements TransactionManagerLookup {
        public synchronized TransactionManager getTransactionManager() throws Exception {
            return tmb;
        }
    }

    public static class TxManagerLookupA
    implements TransactionManagerLookup {
        public synchronized TransactionManager getTransactionManager() throws Exception {
            return tma;
        }
    }
}

