/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration;

import java.util.Properties;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.IsolationLevel;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.factories.threads.EnhancedQueueExecutorFactory;
import org.infinispan.remoting.transport.jgroups.FileJGroupsChannelConfigurator;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="configuration.StringPropertyReplacementTest")
public class StringPropertyReplacementTest
extends AbstractInfinispanTest {
    protected ConfigurationBuilderHolder parse() throws Exception {
        Properties properties = new Properties();
        properties.setProperty("StringPropertyReplacementTest.asyncListenerMaxThreads", "2");
        properties.setProperty("StringPropertyReplacementTest.persistenceMaxThreads", "4");
        properties.setProperty("StringPropertyReplacementTest.IsolationLevel", "READ_COMMITTED");
        properties.setProperty("StringPropertyReplacementTest.writeSkewCheck", "true");
        properties.setProperty("StringPropertyReplacementTest.SyncCommitPhase", "true");
        ParserRegistry parserRegistry = new ParserRegistry(Thread.currentThread().getContextClassLoader(), true, properties);
        return parserRegistry.parseFile("configs/string-property-replaced.xml");
    }

    public void testGlobalConfig() throws Exception {
        ConfigurationBuilderHolder holder = this.parse();
        GlobalConfiguration gc = holder.getGlobalConfigurationBuilder().build();
        EnhancedQueueExecutorFactory listenerThreadPool = (EnhancedQueueExecutorFactory)gc.listenerThreadPool().threadPoolFactory();
        AssertJUnit.assertEquals((int)2, (int)listenerThreadPool.maxThreads());
        EnhancedQueueExecutorFactory blockingThreadPool = (EnhancedQueueExecutorFactory)gc.blockingThreadPool().threadPoolFactory();
        AssertJUnit.assertEquals((int)4, (int)blockingThreadPool.maxThreads());
        FileJGroupsChannelConfigurator transportConfigurator = (FileJGroupsChannelConfigurator)gc.transport().jgroups().configurator(gc.transport().stack());
        AssertJUnit.assertEquals((String)"stacks/tcp.xml", (String)transportConfigurator.getPath());
        Configuration configuration = holder.getDefaultConfigurationBuilder().build();
        AssertJUnit.assertEquals((Object)IsolationLevel.READ_COMMITTED, (Object)configuration.locking().lockIsolationLevel());
    }
}

