/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.marshall;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.UUID;
import org.infinispan.commons.util.Util;
import org.infinispan.test.data.Key;

public class PojoWithAttributes {
    final int age;
    final Key key;
    final UUID uuid;

    public PojoWithAttributes(int age, String key) {
        this.age = age;
        this.key = new Key(key);
        this.uuid = Util.threadLocalRandomUUID();
    }

    PojoWithAttributes(int age, Key key, UUID uuid) {
        this.age = age;
        this.key = key;
        this.uuid = uuid;
    }

    public static void writeObject(ObjectOutput output, PojoWithAttributes pojo) throws IOException {
        output.writeInt(pojo.age);
        output.writeObject(pojo.key);
        output.writeObject(pojo.uuid);
    }

    public static PojoWithAttributes readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        int age = input.readInt();
        Key key = (Key)input.readObject();
        UUID uuid = (UUID)input.readObject();
        return new PojoWithAttributes(age, key, uuid);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PojoWithAttributes that = (PojoWithAttributes)o;
        if (this.age != that.age) {
            return false;
        }
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        return !(this.uuid != null ? !this.uuid.equals(that.uuid) : that.uuid != null);
    }

    public int hashCode() {
        int result = this.age;
        result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
        result = 31 * result + (this.uuid != null ? this.uuid.hashCode() : 0);
        return result;
    }
}

