/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.distribution.MagicKey;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.transaction.TransactionMode;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="commands.PutMapCommandTest")
public class PutMapCommandTest
extends MultipleCacheManagersTest {
    protected int numberOfKeys = 10;
    protected boolean includePersistence;

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder dcc = PutMapCommandTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        dcc.clustering().hash().numOwners(1).l1().disable();
        dcc.locking().transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        dcc.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class);
        this.createCluster(TestDataSCI.INSTANCE, dcc, 4);
        this.waitForClusterToForm();
    }

    PutMapCommandTest includePersistence(boolean includePersistence) {
        this.includePersistence = includePersistence;
        return this;
    }

    @Override
    protected Object[] parameterValues() {
        return new Object[]{this.includePersistence};
    }

    @Override
    protected String[] parameterNames() {
        return new String[]{"persistance"};
    }

    @Override
    public Object[] factory() {
        return new Object[]{new PutMapCommandTest().includePersistence(false), new PutMapCommandTest().includePersistence(true)};
    }

    public void testPutOnNonOwner() {
        MagicKey mk = new MagicKey("key", this.cache(0));
        this.cache(3).getAdvancedCache().withFlags(Flag.SKIP_REMOTE_LOOKUP).put((Object)mk, (Object)"value");
        assert (this.cache(0).getAdvancedCache().withFlags(Flag.SKIP_REMOTE_LOOKUP).get((Object)mk) != null);
        assert (this.cache(1).getAdvancedCache().withFlags(Flag.SKIP_REMOTE_LOOKUP).get((Object)mk) == null);
        assert (this.cache(2).getAdvancedCache().withFlags(Flag.SKIP_REMOTE_LOOKUP).get((Object)mk) == null);
        assert (this.cache(3).getAdvancedCache().withFlags(Flag.SKIP_REMOTE_LOOKUP).get((Object)mk) == null);
    }

    public void testPutMapCommand() {
        int i;
        for (int i2 = 0; i2 < this.numberOfKeys; ++i2) {
            assert (this.cache(0).get((Object)("key" + i2)) == null);
            assert (this.cache(1).get((Object)("key" + i2)) == null);
            assert (this.cache(2).get((Object)("key" + i2)) == null);
            assert (this.cache(3).get((Object)("key" + i2)) == null);
        }
        HashMap<CallSite, CallSite> map = new HashMap<CallSite, CallSite>();
        for (i = 0; i < this.numberOfKeys; ++i) {
            map.put((CallSite)((Object)("key" + i)), (CallSite)((Object)("value" + i)));
        }
        this.cache(0).putAll(map);
        for (i = 0; i < this.numberOfKeys; ++i) {
            AssertJUnit.assertEquals((Object)("value" + i), (Object)this.cache(0).get((Object)("key" + i)));
            int finalI = i;
            this.eventuallyEquals("value" + i, () -> this.cache(1).get((Object)("key" + finalI)));
            this.eventuallyEquals("value" + i, () -> this.cache(2).get((Object)("key" + finalI)));
            this.eventuallyEquals("value" + i, () -> this.cache(3).get((Object)("key" + finalI)));
        }
    }
}

