/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.TreeMap;
import org.infinispan.commands.LocalCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commons.util.ClassFinder;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.Mocks;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="commands.CommandIdUniquenessTest")
public class CommandIdUniquenessTest
extends AbstractInfinispanTest {
    public void testCommandIdUniqueness() throws Exception {
        List commands = ClassFinder.isAssignableFrom(ReplicableCommand.class);
        TreeMap<Byte, String> cmdIds = new TreeMap<Byte, String>();
        for (Class c : commands) {
            if (c.isInterface() || Modifier.isAbstract(c.getModifiers()) || LocalCommand.class.isAssignableFrom(c) || c.getName().contains(Mocks.class.getName())) continue;
            log.infof("Testing %s", (Object)c.getSimpleName());
            Constructor<?>[] declaredCtors = c.getDeclaredConstructors();
            Constructor<?> constructor = null;
            for (Constructor<?> declaredCtor : declaredCtors) {
                if (declaredCtor.getParameterCount() != 0) continue;
                constructor = declaredCtor;
                constructor.setAccessible(true);
                break;
            }
            AssertJUnit.assertNotNull((String)("Empty constructor not found for " + c.getSimpleName()), constructor);
            ReplicableCommand cmd = (ReplicableCommand)constructor.newInstance(new Object[0]);
            byte b = cmd.getCommandId();
            assert (b > 0) : "Command " + c.getSimpleName() + " has a command id of " + b + " and does not implement LocalCommand!";
            assert (!cmdIds.containsKey(b)) : "Command ID [" + b + "] is duplicated in " + c.getSimpleName() + " and " + (String)cmdIds.get(b);
            cmdIds.put(b, c.getSimpleName());
        }
    }
}

