/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.mvcc;

import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import java.util.Collections;
import org.infinispan.Cache;
import org.infinispan.api.mvcc.LockAssert;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IsolationLevel;
import org.infinispan.manager.CacheContainer;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.infinispan.transaction.tm.EmbeddedTransaction;
import org.infinispan.transaction.tm.EmbeddedTransactionManager;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public abstract class LockTestBase
extends AbstractInfinispanTest {
    private final Log log = LogFactory.getLog(LockTestBase.class);
    protected boolean repeatableRead = true;
    private CacheContainer cm;
    protected LockTestData lockTestData;

    @BeforeMethod
    public void setUp() {
        LockTestData ltd = new LockTestData();
        ConfigurationBuilder defaultCfg = TestCacheManagerFactory.getDefaultCacheConfiguration(true);
        defaultCfg.locking().isolationLevel(this.repeatableRead ? IsolationLevel.REPEATABLE_READ : IsolationLevel.READ_COMMITTED).lockAcquisitionTimeout(TestingUtil.shortTimeoutMillis()).transaction().transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup());
        this.cm = TestCacheManagerFactory.createCacheManager(defaultCfg);
        ltd.cache = this.cm.getCache();
        ltd.lockManager = (LockManager)TestingUtil.extractComponentRegistry(ltd.cache).getComponent(LockManager.class);
        ltd.tm = (EmbeddedTransactionManager)TestingUtil.extractComponentRegistry(ltd.cache).getComponent(TransactionManager.class);
        this.lockTestData = ltd;
    }

    @AfterMethod
    public void tearDown() {
        this.log.debug((Object)"**** - STARTING TEARDOWN - ****");
        TestingUtil.killCacheManagers(this.cm);
        this.lockTestData = null;
    }

    protected void assertLocked(Object key) {
        LockAssert.assertLocked(key, this.lockTestData.lockManager);
    }

    protected void assertNotLocked(Object key) {
        LockAssert.assertNotLocked(key, this.lockTestData.lockManager);
    }

    protected void assertNoLocks() {
        LockAssert.assertNoLocks(this.lockTestData.lockManager);
    }

    public void testLocksOnPutKeyVal() throws Exception {
        Cache<String, String> cache = this.lockTestData.cache;
        EmbeddedTransactionManager tm = this.lockTestData.tm;
        tm.begin();
        cache.put((Object)"k", (Object)"v");
        AssertJUnit.assertTrue((boolean)tm.getTransaction().runPrepare());
        this.assertLocked("k");
        tm.getTransaction().runCommit(false);
        this.assertNoLocks();
        tm.begin();
        AssertJUnit.assertEquals((String)"v", (String)((String)cache.get((Object)"k")));
        this.assertNotLocked("k");
        tm.commit();
        this.assertNoLocks();
        tm.begin();
        cache.remove((Object)"k");
        AssertJUnit.assertTrue((boolean)tm.getTransaction().runPrepare());
        this.assertLocked("k");
        tm.getTransaction().runCommit(false);
        this.assertNoLocks();
    }

    public void testLocksOnPutData() throws Exception {
        LockTestData tl = this.lockTestData;
        Cache<String, String> cache = tl.cache;
        EmbeddedTransactionManager tm = tl.tm;
        tm.begin();
        cache.putAll(Collections.singletonMap("k", "v"));
        AssertJUnit.assertEquals((String)"v", (String)((String)cache.get((Object)"k")));
        EmbeddedTransaction tx = tm.getTransaction();
        AssertJUnit.assertTrue((boolean)tx.runPrepare());
        this.assertLocked("k");
        tx.runCommit(false);
        this.assertNoLocks();
        tm.begin();
        AssertJUnit.assertEquals((String)"v", (String)((String)cache.get((Object)"k")));
        this.assertNoLocks();
        tm.commit();
        this.assertNoLocks();
    }

    public void testLocksOnEvict() throws Exception {
        LockTestData tl = this.lockTestData;
        Cache<String, String> cache = tl.cache;
        EmbeddedTransactionManager tm = tl.tm;
        cache.putAll(Collections.singletonMap("k", "v"));
        AssertJUnit.assertEquals((String)"v", (String)((String)cache.get((Object)"k")));
        tm.begin();
        cache.evict((Object)"k");
        this.assertNotLocked("k");
        tm.commit();
        AssertJUnit.assertFalse((boolean)cache.containsKey((Object)"k"));
        this.assertNoLocks();
    }

    public void testLocksOnRemoveNonexistent() throws Exception {
        LockTestData tl = this.lockTestData;
        Cache<String, String> cache = tl.cache;
        EmbeddedTransactionManager tm = tl.tm;
        assert (!cache.containsKey((Object)"k")) : "Should not exist";
        tm.begin();
        cache.remove((Object)"k");
        tm.getTransaction().runPrepare();
        this.assertLocked("k");
        tm.getTransaction().runCommit(false);
        assert (!cache.containsKey((Object)"k")) : "Should not exist";
        this.assertNoLocks();
    }

    public void testLocksOnEvictNonexistent() throws Exception {
        LockTestData tl = this.lockTestData;
        Cache<String, String> cache = tl.cache;
        EmbeddedTransactionManager tm = tl.tm;
        assert (!cache.containsKey((Object)"k")) : "Should not exist";
        tm.begin();
        cache.evict((Object)"k");
        this.assertNotLocked("k");
        tm.commit();
        assert (!cache.containsKey((Object)"k")) : "Should not exist";
        this.assertNoLocks();
    }

    public void testLocksOnRemoveData() throws Exception {
        LockTestData tl = this.lockTestData;
        Cache<String, String> cache = tl.cache;
        EmbeddedTransactionManager tm = tl.tm;
        cache.put((Object)"k", (Object)"v");
        cache.put((Object)"k2", (Object)"v2");
        AssertJUnit.assertEquals((String)"v", (String)((String)cache.get((Object)"k")));
        AssertJUnit.assertEquals((String)"v2", (String)((String)cache.get((Object)"k2")));
        tm.begin();
        cache.remove((Object)"k");
        cache.remove((Object)"k2");
        AssertJUnit.assertTrue((boolean)tm.getTransaction().runPrepare());
        this.assertLocked("k");
        this.assertLocked("k2");
        tm.getTransaction().runCommit(false);
        assert (cache.isEmpty());
        this.assertNoLocks();
    }

    public void testWriteDoesntBlockRead() throws Exception {
        LockTestData tl = this.lockTestData;
        Cache<String, String> cache = tl.cache;
        EmbeddedTransactionManager tm = tl.tm;
        cache.put((Object)"k", (Object)"v");
        tm.begin();
        cache.put((Object)"k2", (Object)"v2");
        Transaction write = tm.suspend();
        tm.begin();
        AssertJUnit.assertEquals((String)"v", (String)((String)cache.get((Object)"k")));
        assert (null == cache.get((Object)"k2")) : "Should not see uncommitted changes";
        Transaction read = tm.suspend();
        tm.resume(write);
        tm.commit();
        this.assertNoLocks();
        tm.resume(read);
        String value = (String)cache.get((Object)"k2");
        if (this.repeatableRead) {
            assert (null == value) : "Should have repeatable read";
        } else {
            AssertJUnit.assertTrue((null == value || "v2".equals(value) ? 1 : 0) != 0);
        }
        tm.commit();
        this.assertNoLocks();
    }

    public void testUpdateDoesntBlockRead() throws Exception {
        LockTestData tl = this.lockTestData;
        Cache<String, String> cache = tl.cache;
        EmbeddedTransactionManager tm = tl.tm;
        cache.put((Object)"k", (Object)"v");
        tm.begin();
        cache.put((Object)"k", (Object)"v2");
        Transaction write = tm.suspend();
        tm.begin();
        AssertJUnit.assertEquals((String)"v", (String)((String)cache.get((Object)"k")));
        Transaction read = tm.suspend();
        tm.resume(write);
        tm.commit();
        this.assertNoLocks();
        tm.resume(read);
        if (this.repeatableRead) {
            AssertJUnit.assertEquals((String)"Should have repeatable read", (String)"v", (String)((String)cache.get((Object)"k")));
        } else {
            AssertJUnit.assertEquals((String)"Read committed should see committed changes", (String)"v2", (String)((String)cache.get((Object)"k")));
        }
        tm.commit();
        this.assertNoLocks();
    }

    public void testWriteDoesntBlockReadNonexistent() throws Exception {
        LockTestData tl = this.lockTestData;
        Cache<String, String> cache = tl.cache;
        EmbeddedTransactionManager tm = tl.tm;
        tm.begin();
        cache.put((Object)"k", (Object)"v");
        Transaction write = tm.suspend();
        tm.begin();
        assert (null == cache.get((Object)"k")) : "Should not see uncommitted changes";
        Transaction read = tm.suspend();
        tm.resume(write);
        tm.commit();
        this.assertNoLocks();
        tm.resume(read);
        String value = (String)cache.get((Object)"k");
        if (this.repeatableRead) {
            assert (null == value) : "Should have repeatable read";
        } else {
            AssertJUnit.assertTrue((null == value || "v".equals(value) ? 1 : 0) != 0);
        }
        tm.commit();
        this.assertNoLocks();
    }

    public void testConcurrentWriters() throws Exception {
        LockTestData tl = this.lockTestData;
        Cache<String, String> cache = tl.cache;
        EmbeddedTransactionManager tm = tl.tm;
        tm.begin();
        cache.put((Object)"k", (Object)"v");
        EmbeddedTransaction transaction = tm.getTransaction();
        AssertJUnit.assertTrue((boolean)transaction.runPrepare());
        tm.suspend();
        tm.begin();
        cache.put((Object)"k", (Object)"v");
        assert (!tm.getTransaction().runPrepare());
        tm.rollback();
        tm.resume((Transaction)transaction);
        transaction.runCommit(false);
        this.assertNoLocks();
    }

    public void testRollbacks() throws Exception {
        LockTestData tl = this.lockTestData;
        Cache<String, String> cache = tl.cache;
        EmbeddedTransactionManager tm = tl.tm;
        cache.put((Object)"k", (Object)"v");
        tm.begin();
        AssertJUnit.assertEquals((String)"v", (String)((String)cache.get((Object)"k")));
        Transaction reader = tm.suspend();
        tm.begin();
        cache.put((Object)"k", (Object)"v2");
        tm.rollback();
        tm.resume(reader);
        Object value = cache.get((Object)"k");
        AssertJUnit.assertEquals((Object)"v", (Object)value);
        tm.commit();
        AssertJUnit.assertEquals((String)"v", (String)((String)cache.get((Object)"k")));
        this.assertNoLocks();
    }

    public void testRollbacksOnNullEntry() throws Exception {
        LockTestData tl = this.lockTestData;
        Cache<String, String> cache = tl.cache;
        EmbeddedTransactionManager tm = tl.tm;
        tm.begin();
        assert (null == cache.get((Object)"k"));
        Transaction reader = tm.suspend();
        tm.begin();
        cache.put((Object)"k", (Object)"v");
        AssertJUnit.assertEquals((String)"v", (String)((String)cache.get((Object)"k")));
        tm.rollback();
        tm.resume(reader);
        assert (null == cache.get((Object)"k")) : "Expecting null but was " + (String)cache.get((Object)"k");
        tm.commit();
        assert (null == cache.get((Object)"k"));
        this.assertNoLocks();
    }

    protected static final class LockTestData {
        public Cache<String, String> cache;
        public EmbeddedTransactionManager tm;
        public LockManager lockManager;

        protected LockTestData() {
        }
    }
}

