/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.batch;

import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.batch.LockInBatchTest")
public class LockInBatchTest
extends SingleCacheManagerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder dccc = LockInBatchTest.getDefaultClusteredCacheConfig(CacheMode.LOCAL, false);
        dccc.transaction().transactionMode(TransactionMode.TRANSACTIONAL).lockingMode(LockingMode.PESSIMISTIC);
        dccc.invocationBatching().enable(true);
        return TestCacheManagerFactory.createCacheManager(dccc);
    }

    public void testLockWithBatchingRollback() {
        this.cache.startBatch();
        this.cache.getAdvancedCache().lock(new Object[]{"k"});
        Assert.assertTrue((boolean)this.lockManager().isLocked((Object)"k"));
        this.cache().endBatch(false);
        Assert.assertFalse((boolean)this.lockManager().isLocked((Object)"k"));
    }

    public void testLockWithBatchingCommit() {
        this.cache.startBatch();
        this.cache.getAdvancedCache().lock(new Object[]{"k"});
        Assert.assertTrue((boolean)this.lockManager().isLocked((Object)"k"));
        this.cache().endBatch(true);
        Assert.assertFalse((boolean)this.lockManager().isLocked((Object)"k"));
    }

    public void testLockWithTmRollback() throws Throwable {
        this.tm().begin();
        this.cache.getAdvancedCache().lock(new Object[]{"k"});
        Assert.assertTrue((boolean)this.lockManager().isLocked((Object)"k"));
        this.tm().rollback();
        Assert.assertFalse((boolean)this.lockManager().isLocked((Object)"k"));
    }

    public void testLockWithTmCommit() throws Throwable {
        this.tm().begin();
        this.cache.getAdvancedCache().lock(new Object[]{"k"});
        Assert.assertTrue((boolean)this.lockManager().isLocked((Object)"k"));
        this.tm().commit();
        Assert.assertFalse((boolean)this.lockManager().isLocked((Object)"k"));
    }
}

