/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$generator$;

import java.lang.ref.WeakReference;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.TypeElement;
import org.immutables.value.internal.$guava$.base.$Preconditions;
import org.immutables.value.internal.$guava$.base.$Supplier;
import org.immutables.value.internal.$guava$.collect.$ClassToInstanceMap;
import org.immutables.value.internal.$guava$.collect.$ImmutableSet;
import org.immutables.value.internal.$guava$.collect.$MutableClassToInstanceMap;

public class $EnvironmentState {
    private static final ThreadLocal<WeakReference<$EnvironmentState>> currentState = new ThreadLocal();
    private ProcessingEnvironment processing;
    private RoundEnvironment round;
    private Set<TypeElement> annotations;
    private final $ClassToInstanceMap<Runnable> afterProcessing = $MutableClassToInstanceMap.create();
    private final $ClassToInstanceMap<Runnable> afterRound = $MutableClassToInstanceMap.create();

    private static $EnvironmentState state() {
        WeakReference<$EnvironmentState> reference = $Preconditions.checkNotNull(currentState.get(), "Static environment should be initialized");
        return ($EnvironmentState)$Preconditions.checkNotNull(reference.get(), "State should still be strongly referenced elsewhere");
    }

    public static <T extends Runnable> T getPerRound(Class<T> type, $Supplier<T> supplier) {
        $EnvironmentState state = $EnvironmentState.state();
        Runnable instance = (Runnable)state.afterRound.getInstance(type);
        if (instance == null) {
            instance = (Runnable)supplier.get();
            state.afterRound.putInstance(type, instance);
        }
        return (T)instance;
    }

    public static <T extends Runnable> T getPerProcessing(Class<T> type, $Supplier<T> supplier) {
        $EnvironmentState state = $EnvironmentState.state();
        Runnable instance = (Runnable)state.afterProcessing.getInstance(type);
        if (instance == null) {
            instance = (Runnable)supplier.get();
            state.afterProcessing.putInstance(type, instance);
        }
        return (T)instance;
    }

    public static ProcessingEnvironment processing() {
        return $EnvironmentState.state().processing;
    }

    public static RoundEnvironment round() {
        return $EnvironmentState.state().round;
    }

    static Set<TypeElement> annotations() {
        return $EnvironmentState.state().annotations;
    }

    void initProcessing(ProcessingEnvironment processing) {
        this.processing = processing;
        currentState.set(new WeakReference<$EnvironmentState>(this));
    }

    void initRound(Set<? extends TypeElement> annotations, RoundEnvironment round) {
        this.round = round;
        this.annotations = $ImmutableSet.copyOf(annotations);
        currentState.set(new WeakReference<$EnvironmentState>(this));
    }

    void completeRound() {
        for (Runnable r : this.afterRound.values()) {
            r.run();
        }
        this.afterRound.clear();
        this.annotations = null;
    }

    void completeProcessing() {
        for (Runnable r : this.afterProcessing.values()) {
            r.run();
        }
        this.afterProcessing.clear();
        currentState.remove();
    }
}

