/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript;

import java.util.Collections;
import java.util.Iterator;
import org.htmlunit.corejs.javascript.EmbeddedSlotMap;
import org.htmlunit.corejs.javascript.HashSlotMap;
import org.htmlunit.corejs.javascript.Slot;
import org.htmlunit.corejs.javascript.SlotMap;

class SlotMapContainer
implements SlotMap {
    private static final int LARGE_HASH_SIZE = 2000;
    private static final int DEFAULT_SIZE = 10;
    private static EmptySlotMap EMPTY_SLOT_MAP = new EmptySlotMap();
    protected SlotMap map;

    SlotMapContainer() {
        this(10);
    }

    SlotMapContainer(int initialSize) {
        this.map = initialSize == 0 ? EMPTY_SLOT_MAP : (initialSize > 2000 ? new HashSlotMap() : new EmbeddedSlotMap());
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public int dirtySize() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Slot modify(Object key, int index, int attributes) {
        this.checkMapSize();
        return this.map.modify(key, index, attributes);
    }

    @Override
    public <S extends Slot> S compute(Object key, int index, SlotMap.SlotComputer<S> c) {
        this.checkMapSize();
        return this.map.compute(key, index, c);
    }

    @Override
    public Slot query(Object key, int index) {
        return this.map.query(key, index);
    }

    @Override
    public void add(Slot newSlot) {
        this.checkMapSize();
        this.map.add(newSlot);
    }

    @Override
    public Iterator<Slot> iterator() {
        return this.map.iterator();
    }

    public long readLock() {
        return 0L;
    }

    public void unlockRead(long stamp) {
    }

    protected void checkMapSize() {
        if (this.map == EMPTY_SLOT_MAP) {
            this.map = new EmbeddedSlotMap();
        } else if (this.map instanceof EmbeddedSlotMap && this.map.size() >= 2000) {
            HashSlotMap newMap = new HashSlotMap(this.map);
            this.map = newMap;
        }
    }

    private static class EmptySlotMap
    implements SlotMap {
        private EmptySlotMap() {
        }

        @Override
        public Iterator<Slot> iterator() {
            return Collections.emptyIterator();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public Slot modify(Object key, int index, int attributes) {
            return null;
        }

        @Override
        public Slot query(Object key, int index) {
            return null;
        }

        @Override
        public void add(Slot newSlot) {
            throw new IllegalStateException();
        }

        @Override
        public <S extends Slot> S compute(Object key, int index, SlotMap.SlotComputer<S> compute) {
            throw new IllegalStateException();
        }
    }
}

