/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript;

import org.htmlunit.corejs.javascript.Token;

abstract class Icode {
    static final int Icode_DELNAME = 0;
    static final int Icode_DUP = -1;
    static final int Icode_DUP2 = -2;
    static final int Icode_SWAP = -3;
    static final int Icode_POP = -4;
    static final int Icode_POP_RESULT = -5;
    static final int Icode_IFEQ_POP = -6;
    static final int Icode_VAR_INC_DEC = -7;
    static final int Icode_NAME_INC_DEC = -8;
    static final int Icode_PROP_INC_DEC = -9;
    static final int Icode_ELEM_INC_DEC = -10;
    static final int Icode_REF_INC_DEC = -11;
    static final int Icode_SCOPE_LOAD = -12;
    static final int Icode_SCOPE_SAVE = -13;
    static final int Icode_TYPEOFNAME = -14;
    static final int Icode_NAME_AND_THIS = -15;
    static final int Icode_PROP_AND_THIS = -16;
    static final int Icode_ELEM_AND_THIS = -17;
    static final int Icode_VALUE_AND_THIS = -18;
    static final int Icode_NAME_AND_THIS_OPTIONAL = -19;
    static final int Icode_PROP_AND_THIS_OPTIONAL = -20;
    static final int Icode_ELEM_AND_THIS_OPTIONAL = -21;
    static final int Icode_VALUE_AND_THIS_OPTIONAL = -22;
    static final int Icode_CLOSURE_EXPR = -23;
    static final int Icode_CLOSURE_STMT = -24;
    static final int Icode_CALLSPECIAL = -25;
    static final int Icode_CALLSPECIAL_OPTIONAL = -26;
    static final int Icode_RETUNDEF = -27;
    static final int Icode_GOSUB = -28;
    static final int Icode_STARTSUB = -29;
    static final int Icode_RETSUB = -30;
    static final int Icode_LINE = -31;
    static final int Icode_SHORTNUMBER = -32;
    static final int Icode_INTNUMBER = -33;
    static final int Icode_LITERAL_NEW_OBJECT = -34;
    static final int Icode_LITERAL_NEW_ARRAY = -35;
    static final int Icode_LITERAL_SET = -36;
    static final int ICode_FN_STORE_HOME_OBJECT = -37;
    static final int Icode_SPARE_ARRAYLIT = -38;
    static final int Icode_REG_IND_C0 = -39;
    static final int Icode_REG_IND_C1 = -40;
    static final int Icode_REG_IND_C2 = -41;
    static final int Icode_REG_IND_C3 = -42;
    static final int Icode_REG_IND_C4 = -43;
    static final int Icode_REG_IND_C5 = -44;
    static final int Icode_REG_IND1 = -45;
    static final int Icode_REG_IND2 = -46;
    static final int Icode_REG_IND4 = -47;
    static final int Icode_REG_STR_C0 = -48;
    static final int Icode_REG_STR_C1 = -49;
    static final int Icode_REG_STR_C2 = -50;
    static final int Icode_REG_STR_C3 = -51;
    static final int Icode_REG_STR1 = -52;
    static final int Icode_REG_STR2 = -53;
    static final int Icode_REG_STR4 = -54;
    static final int Icode_GETVAR1 = -55;
    static final int Icode_SETVAR1 = -56;
    static final int Icode_UNDEF = -57;
    static final int Icode_ZERO = -58;
    static final int Icode_ONE = -59;
    static final int Icode_ENTERDQ = -60;
    static final int Icode_LEAVEDQ = -61;
    static final int Icode_TAIL_CALL = -62;
    static final int Icode_LOCAL_CLEAR = -63;
    static final int Icode_LITERAL_GETTER = -64;
    static final int Icode_LITERAL_SETTER = -65;
    static final int Icode_SETCONST = -66;
    static final int Icode_SETCONSTVAR = -67;
    static final int Icode_SETCONSTVAR1 = -68;
    static final int Icode_GENERATOR = -69;
    static final int Icode_GENERATOR_END = -70;
    static final int Icode_DEBUGGER = -71;
    static final int Icode_GENERATOR_RETURN = -72;
    static final int Icode_YIELD_STAR = -73;
    static final int Icode_REG_BIGINT_C0 = -74;
    static final int Icode_REG_BIGINT_C1 = -75;
    static final int Icode_REG_BIGINT_C2 = -76;
    static final int Icode_REG_BIGINT_C3 = -77;
    static final int Icode_REG_BIGINT1 = -78;
    static final int Icode_REG_BIGINT2 = -79;
    static final int Icode_REG_BIGINT4 = -80;
    static final int Icode_TEMPLATE_LITERAL_CALLSITE = -81;
    static final int Icode_LITERAL_KEY_SET = -82;
    static final int Icode_IF_NULL_UNDEF = -83;
    static final int Icode_IF_NOT_NULL_UNDEF = -84;
    static final int Icode_CALL_ON_SUPER = -85;
    static final int Icode_DELPROP_SUPER = -86;
    static final int MIN_ICODE = -86;

    Icode() {
    }

    static String bytecodeName(int bytecode) {
        if (!Icode.validBytecode(bytecode)) {
            throw new IllegalArgumentException(String.valueOf(bytecode));
        }
        if (!Token.printICode) {
            return String.valueOf(bytecode);
        }
        if (Icode.validTokenCode(bytecode)) {
            return Token.name(bytecode);
        }
        switch (bytecode) {
            case 0: {
                return "DELNAME";
            }
            case -1: {
                return "DUP";
            }
            case -2: {
                return "DUP2";
            }
            case -3: {
                return "SWAP";
            }
            case -4: {
                return "POP";
            }
            case -5: {
                return "POP_RESULT";
            }
            case -6: {
                return "IFEQ_POP";
            }
            case -7: {
                return "VAR_INC_DEC";
            }
            case -8: {
                return "NAME_INC_DEC";
            }
            case -9: {
                return "PROP_INC_DEC";
            }
            case -10: {
                return "ELEM_INC_DEC";
            }
            case -11: {
                return "REF_INC_DEC";
            }
            case -12: {
                return "SCOPE_LOAD";
            }
            case -13: {
                return "SCOPE_SAVE";
            }
            case -14: {
                return "TYPEOFNAME";
            }
            case -15: {
                return "NAME_AND_THIS";
            }
            case -16: {
                return "PROP_AND_THIS";
            }
            case -17: {
                return "ELEM_AND_THIS";
            }
            case -18: {
                return "VALUE_AND_THIS";
            }
            case -19: {
                return "NAME_AND_THIS_OPTIONAL";
            }
            case -20: {
                return "PROP_AND_THIS_OPTIONAL";
            }
            case -21: {
                return "ELEM_AND_THIS_OPTIONAL";
            }
            case -22: {
                return "VALUE_AND_THIS_OPTIONAL";
            }
            case -23: {
                return "CLOSURE_EXPR";
            }
            case -24: {
                return "CLOSURE_STMT";
            }
            case -25: {
                return "CALLSPECIAL";
            }
            case -26: {
                return "CALLSPECIAL_OPTIONAL";
            }
            case -27: {
                return "RETUNDEF";
            }
            case -28: {
                return "GOSUB";
            }
            case -29: {
                return "STARTSUB";
            }
            case -30: {
                return "RETSUB";
            }
            case -31: {
                return "LINE";
            }
            case -32: {
                return "SHORTNUMBER";
            }
            case -33: {
                return "INTNUMBER";
            }
            case -34: {
                return "LITERAL_NEW_OBJECT";
            }
            case -35: {
                return "LITERAL_NEW_ARRAY";
            }
            case -36: {
                return "LITERAL_SET";
            }
            case -37: {
                return "FN_STORE_HOME_OBJECT";
            }
            case -38: {
                return "SPARE_ARRAYLIT";
            }
            case -39: {
                return "REG_IND_C0";
            }
            case -40: {
                return "REG_IND_C1";
            }
            case -41: {
                return "REG_IND_C2";
            }
            case -42: {
                return "REG_IND_C3";
            }
            case -43: {
                return "REG_IND_C4";
            }
            case -44: {
                return "REG_IND_C5";
            }
            case -45: {
                return "LOAD_IND1";
            }
            case -46: {
                return "LOAD_IND2";
            }
            case -47: {
                return "LOAD_IND4";
            }
            case -48: {
                return "REG_STR_C0";
            }
            case -49: {
                return "REG_STR_C1";
            }
            case -50: {
                return "REG_STR_C2";
            }
            case -51: {
                return "REG_STR_C3";
            }
            case -52: {
                return "LOAD_STR1";
            }
            case -53: {
                return "LOAD_STR2";
            }
            case -54: {
                return "LOAD_STR4";
            }
            case -55: {
                return "GETVAR1";
            }
            case -56: {
                return "SETVAR1";
            }
            case -57: {
                return "UNDEF";
            }
            case -58: {
                return "ZERO";
            }
            case -59: {
                return "ONE";
            }
            case -60: {
                return "ENTERDQ";
            }
            case -61: {
                return "LEAVEDQ";
            }
            case -62: {
                return "TAIL_CALL";
            }
            case -63: {
                return "LOCAL_CLEAR";
            }
            case -64: {
                return "LITERAL_GETTER";
            }
            case -65: {
                return "LITERAL_SETTER";
            }
            case -66: {
                return "SETCONST";
            }
            case -67: {
                return "SETCONSTVAR";
            }
            case -68: {
                return "SETCONSTVAR1";
            }
            case -69: {
                return "GENERATOR";
            }
            case -70: {
                return "GENERATOR_END";
            }
            case -71: {
                return "DEBUGGER";
            }
            case -72: {
                return "GENERATOR_RETURN";
            }
            case -73: {
                return "YIELD_STAR";
            }
            case -74: {
                return "REG_BIGINT_C0";
            }
            case -75: {
                return "REG_BIGINT_C1";
            }
            case -76: {
                return "REG_BIGINT_C2";
            }
            case -77: {
                return "REG_BIGINT_C3";
            }
            case -78: {
                return "LOAD_BIGINT1";
            }
            case -79: {
                return "LOAD_BIGINT2";
            }
            case -80: {
                return "LOAD_BIGINT4";
            }
            case -81: {
                return "TEMPLATE_LITERAL_CALLSITE";
            }
            case -82: {
                return "LITERAL_KEY_SET";
            }
            case -83: {
                return "IF_NULL_UNDEF";
            }
            case -84: {
                return "IF_NOT_NULL_UNDEF";
            }
            case -85: {
                return "CALL_ON_SUPER";
            }
            case -86: {
                return "DELPROP_SUPER";
            }
        }
        throw new IllegalStateException(String.valueOf(bytecode));
    }

    static boolean validIcode(int icode) {
        return -86 <= icode && icode <= 0;
    }

    static boolean validTokenCode(int token) {
        return 2 <= token && token <= 89;
    }

    static boolean validBytecode(int bytecode) {
        return Icode.validIcode(bytecode) || Icode.validTokenCode(bytecode);
    }
}

