/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine.tracking;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.validator.internal.engine.tracking.ProcessedBeansTrackingStrategy;
import org.hibernate.validator.internal.engine.valueextraction.ValueExtractorDescriptor;
import org.hibernate.validator.internal.metadata.aggregated.BeanMetaData;
import org.hibernate.validator.internal.metadata.aggregated.CascadingMetaData;
import org.hibernate.validator.internal.metadata.aggregated.ContainerCascadingMetaData;
import org.hibernate.validator.internal.metadata.aggregated.PotentiallyContainerCascadingMetaData;
import org.hibernate.validator.internal.metadata.aggregated.ReturnValueMetaData;
import org.hibernate.validator.internal.metadata.aggregated.ValidatableParametersMetaData;
import org.hibernate.validator.internal.metadata.facets.Cascadable;
import org.hibernate.validator.internal.metadata.facets.Validatable;
import org.hibernate.validator.internal.util.CollectionHelper;

public class PredefinedScopeProcessedBeansTrackingStrategy
implements ProcessedBeansTrackingStrategy {
    private final Map<Class<?>, Boolean> trackingEnabledForBeans;

    public PredefinedScopeProcessedBeansTrackingStrategy(Map<Class<?>, BeanMetaData<?>> rawBeanMetaDataMap) {
        this.trackingEnabledForBeans = CollectionHelper.toImmutableMap(new TrackingEnabledStrategyBuilder(rawBeanMetaDataMap).build());
    }

    private static void processSingleCascadable(Cascadable cascadable, Set<Class<?>> directCascadedBeanClasses) {
        CascadingMetaData cascadingMetaData = cascadable.getCascadingMetaData();
        if (cascadingMetaData.isContainer()) {
            ContainerCascadingMetaData containerCascadingMetaData = cascadingMetaData.as(ContainerCascadingMetaData.class);
            PredefinedScopeProcessedBeansTrackingStrategy.processContainerCascadingMetaData(containerCascadingMetaData, directCascadedBeanClasses);
        } else if (cascadingMetaData instanceof PotentiallyContainerCascadingMetaData) {
            directCascadedBeanClasses.add(Object.class);
        } else {
            directCascadedBeanClasses.add(PredefinedScopeProcessedBeansTrackingStrategy.typeToClassToProcess(cascadable.getCascadableType()));
        }
    }

    private static void processContainerCascadingMetaData(ContainerCascadingMetaData metaData, Set<Class<?>> directCascadedBeanClasses) {
        if (metaData.isCascading()) {
            if (metaData.getDeclaredTypeParameterIndex() != null) {
                Type type = metaData.getEnclosingType();
                if (type instanceof ParameterizedType) {
                    ParameterizedType parameterizedType = (ParameterizedType)type;
                    Type typeArgument = parameterizedType.getActualTypeArguments()[metaData.getDeclaredTypeParameterIndex()];
                    if (typeArgument instanceof Class) {
                        Class typeArgumentClass = (Class)typeArgument;
                        directCascadedBeanClasses.add(typeArgumentClass);
                    } else if (typeArgument instanceof TypeVariable) {
                        TypeVariable typeVariable = (TypeVariable)typeArgument;
                        for (Type bound : typeVariable.getBounds()) {
                            directCascadedBeanClasses.add(PredefinedScopeProcessedBeansTrackingStrategy.typeToClassToProcess(bound));
                        }
                    } else if (typeArgument instanceof WildcardType) {
                        WildcardType wildcard = (WildcardType)typeArgument;
                        for (Type bound : wildcard.getUpperBounds()) {
                            directCascadedBeanClasses.add(PredefinedScopeProcessedBeansTrackingStrategy.typeToClassToProcess(bound));
                        }
                        if (wildcard.getLowerBounds().length != 0) {
                            directCascadedBeanClasses.add(Object.class);
                        }
                    } else {
                        directCascadedBeanClasses.add(Object.class);
                    }
                }
            } else {
                for (ValueExtractorDescriptor valueExtractorCandidate : metaData.getValueExtractorCandidates()) {
                    valueExtractorCandidate.getExtractedType().ifPresent(directCascadedBeanClasses::add);
                }
            }
        }
        for (ContainerCascadingMetaData sub : metaData.getContainerElementTypesCascadingMetaData()) {
            PredefinedScopeProcessedBeansTrackingStrategy.processContainerCascadingMetaData(sub, directCascadedBeanClasses);
        }
    }

    private static Class<?> typeToClassToProcess(Type type) {
        if (type instanceof Class) {
            Class cascadableClass = (Class)type;
            return cascadableClass;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return PredefinedScopeProcessedBeansTrackingStrategy.typeToClassToProcess(parameterizedType.getRawType());
        }
        return Object.class;
    }

    @Override
    public boolean isEnabledForBean(Class<?> rootBeanClass, boolean hasCascadables) {
        if (!hasCascadables) {
            return false;
        }
        return this.trackingEnabledForBeans.get(rootBeanClass);
    }

    @Override
    public boolean isEnabledForReturnValue(ReturnValueMetaData returnValueMetaData) {
        return this.isEnabledForExecutableValidatable(returnValueMetaData);
    }

    @Override
    public boolean isEnabledForParameters(ValidatableParametersMetaData parametersMetaData) {
        return this.isEnabledForExecutableValidatable(parametersMetaData);
    }

    private boolean isEnabledForExecutableValidatable(Validatable validatable) {
        if (!validatable.hasCascadables()) {
            return false;
        }
        HashSet directCascadedBeanClasses = new HashSet();
        for (Cascadable cascadable : validatable.getCascadables()) {
            PredefinedScopeProcessedBeansTrackingStrategy.processSingleCascadable(cascadable, directCascadedBeanClasses);
        }
        for (Class clazz : directCascadedBeanClasses) {
            if (!Boolean.TRUE.equals(this.trackingEnabledForBeans.get(clazz))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.trackingEnabledForBeans.clear();
    }

    private static class TrackingEnabledStrategyBuilder {
        private final Map<Class<?>, BeanMetaData<?>> rawBeanMetaDataMap;
        private final Map<Class<?>, Boolean> classToBeanTrackingEnabled;
        private final Map<Class<?>, Set<Class<?>>> subtypesMap;

        TrackingEnabledStrategyBuilder(Map<Class<?>, BeanMetaData<?>> rawBeanMetaDataMap) {
            this.rawBeanMetaDataMap = rawBeanMetaDataMap;
            this.classToBeanTrackingEnabled = CollectionHelper.newHashMap(rawBeanMetaDataMap.size());
            this.subtypesMap = CollectionHelper.newHashMap(rawBeanMetaDataMap.size());
            for (Class<?> beanClass : rawBeanMetaDataMap.keySet()) {
                for (Class<?> otherBeanClass : rawBeanMetaDataMap.keySet()) {
                    if (!beanClass.isAssignableFrom(otherBeanClass)) continue;
                    this.subtypesMap.computeIfAbsent(beanClass, k -> new HashSet()).add(otherBeanClass);
                }
            }
        }

        public Map<Class<?>, Boolean> build() {
            HashSet beanClassesInPath = new HashSet();
            for (BeanMetaData<?> beanMetadata : this.rawBeanMetaDataMap.values()) {
                this.determineTrackingRequired(beanMetadata.getBeanClass(), beanClassesInPath);
                if (beanClassesInPath.isEmpty()) continue;
                throw new IllegalStateException("beanClassesInPath not empty");
            }
            return this.classToBeanTrackingEnabled;
        }

        private boolean determineTrackingRequired(Class<?> beanClass, Set<Class<?>> beanClassesInPath) {
            Boolean isBeanTrackingEnabled = this.classToBeanTrackingEnabled.get(beanClass);
            if (isBeanTrackingEnabled != null) {
                return isBeanTrackingEnabled;
            }
            if (!beanClassesInPath.add(beanClass)) {
                for (Class<?> dependency : beanClassesInPath) {
                    this.register(dependency, true);
                }
                beanClassesInPath.clear();
                return true;
            }
            for (Class<?> directCascadedBeanClass : this.getDirectCascadedBeanClasses(beanClass)) {
                Boolean isSubBeanTrackingEnabled = this.classToBeanTrackingEnabled.get(directCascadedBeanClass);
                if (isSubBeanTrackingEnabled != null) {
                    if (!isSubBeanTrackingEnabled.booleanValue()) continue;
                    for (Class<?> dependency : beanClassesInPath) {
                        this.register(dependency, true);
                    }
                    beanClassesInPath.clear();
                    return true;
                }
                if (!this.determineTrackingRequired(directCascadedBeanClass, beanClassesInPath)) continue;
                assert (beanClassesInPath.isEmpty());
                return true;
            }
            beanClassesInPath.remove(beanClass);
            return this.register(beanClass, false);
        }

        private <T> Set<Class<?>> getDirectCascadedBeanClasses(Class<T> beanClass) {
            HashSet directCascadedBeanClasses = new HashSet();
            Set<Class<?>> classes = this.subtypesMap.get(beanClass);
            if (classes == null) {
                return Set.of();
            }
            for (Class<?> otherBeanClass : classes) {
                BeanMetaData<?> beanMetaData = this.rawBeanMetaDataMap.get(otherBeanClass);
                if (beanMetaData == null || !beanMetaData.hasCascadables()) continue;
                for (Cascadable cascadable : beanMetaData.getCascadables()) {
                    PredefinedScopeProcessedBeansTrackingStrategy.processSingleCascadable(cascadable, directCascadedBeanClasses);
                }
            }
            return directCascadedBeanClasses;
        }

        private boolean register(Class<?> beanClass, boolean isBeanTrackingEnabled) {
            if (this.classToBeanTrackingEnabled.put(beanClass, isBeanTrackingEnabled) != null) {
                throw new IllegalStateException(beanClass.getName() + " registered more than once.");
            }
            return isBeanTrackingEnabled;
        }
    }
}

