/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine.path;

import jakarta.validation.Path;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.Iterator;
import org.hibernate.validator.internal.engine.path.MaterializedNode;
import org.hibernate.validator.internal.engine.path.MutablePath;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.path.RandomAccessPath;

final class MaterializedPath
implements RandomAccessPath,
Serializable {
    private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());
    private static final long serialVersionUID = -329465327521818082L;
    private static final String PROPERTY_PATH_SEPARATOR = ".";
    private final MaterializedNode leafNode;
    private final MaterializedNode[] nodes;

    MaterializedPath(MutablePath path) {
        this.nodes = MaterializedNode.constructMaterializedPath(path.getLeafNode());
        this.leafNode = this.nodes[this.nodes.length - 1];
    }

    @Override
    public Path.Node getLeafNode() {
        return this.leafNode;
    }

    @Override
    public Path.Node getRootNode() {
        return this.nodes[0];
    }

    @Override
    public Path.Node getNode(int index) {
        if (index < 0 || index >= this.nodes.length) {
            throw LOG.pathIndexOutOfBounds(index, this.nodes.length);
        }
        return this.nodes[index];
    }

    @Override
    public int length() {
        return this.nodes.length;
    }

    public Iterator<Path.Node> iterator() {
        return new MaterializedNode.NodeIterator(this.nodes);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MaterializedPath other = (MaterializedPath)o;
        return this.leafNode.samePath(other.leafNode);
    }

    public int hashCode() {
        return this.leafNode.hashCode();
    }

    public String toString() {
        return MaterializedPath.asString(this.leafNode);
    }

    static String asString(MaterializedNode currentLeafNode) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        MaterializedNode current = currentLeafNode;
        while (!current.isRootPath()) {
            String name = current.asString();
            if (name.isEmpty()) {
                current = current.getParent();
                continue;
            }
            if (!first) {
                builder.insert(0, PROPERTY_PATH_SEPARATOR);
            }
            builder.insert(0, current.asString());
            first = false;
            current = current.getParent();
        }
        return builder.toString();
    }
}

