/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.schema.management.impl;

import java.nio.file.Path;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import org.hibernate.search.engine.backend.schema.management.spi.IndexSchemaCollector;
import org.hibernate.search.engine.backend.schema.management.spi.IndexSchemaManager;
import org.hibernate.search.engine.backend.work.execution.OperationSubmitter;
import org.hibernate.search.engine.common.schema.management.SchemaExport;
import org.hibernate.search.engine.reporting.spi.ContextualFailureCollector;
import org.hibernate.search.engine.reporting.spi.FailureCollector;
import org.hibernate.search.mapper.pojo.reporting.spi.PojoEventContexts;
import org.hibernate.search.mapper.pojo.schema.management.SearchSchemaCollector;
import org.hibernate.search.mapper.pojo.schema.management.impl.FileSearchSchemaCollector;
import org.hibernate.search.mapper.pojo.schema.management.impl.PojoSchemaManagementIndexedTypeContext;
import org.hibernate.search.mapper.pojo.schema.management.spi.PojoScopeSchemaManager;
import org.hibernate.search.util.common.function.TriFunction;
import org.hibernate.search.util.common.impl.Futures;
import org.hibernate.search.util.common.impl.Throwables;

public class PojoScopeSchemaManagerImpl
implements PojoScopeSchemaManager {
    private final Set<? extends PojoSchemaManagementIndexedTypeContext> targetedTypeContexts;

    public PojoScopeSchemaManagerImpl(Set<? extends PojoSchemaManagementIndexedTypeContext> targetedTypeContexts) {
        this.targetedTypeContexts = targetedTypeContexts;
    }

    @Override
    public CompletableFuture<?> createIfMissing(FailureCollector failureCollector, OperationSubmitter operationSubmitter) {
        return this.doOperationOnTypesBiFunction(IndexSchemaManager::createIfMissing, failureCollector, operationSubmitter);
    }

    @Override
    public CompletableFuture<?> createOrValidate(FailureCollector failureCollector, OperationSubmitter operationSubmitter) {
        return this.doOperationOnTypesTriFunction(IndexSchemaManager::createOrValidate, failureCollector, operationSubmitter);
    }

    @Override
    public CompletableFuture<?> createOrUpdate(FailureCollector failureCollector, OperationSubmitter operationSubmitter) {
        return this.doOperationOnTypesBiFunction(IndexSchemaManager::createOrUpdate, failureCollector, operationSubmitter);
    }

    @Override
    public CompletableFuture<?> dropAndCreate(FailureCollector failureCollector, OperationSubmitter operationSubmitter) {
        return this.doOperationOnTypesBiFunction(IndexSchemaManager::dropAndCreate, failureCollector, operationSubmitter);
    }

    @Override
    public CompletableFuture<?> dropIfExisting(FailureCollector failureCollector, OperationSubmitter operationSubmitter) {
        return this.doOperationOnTypesBiFunction(IndexSchemaManager::dropIfExisting, failureCollector, operationSubmitter);
    }

    @Override
    public CompletableFuture<?> validate(FailureCollector failureCollector, OperationSubmitter operationSubmitter) {
        return this.doOperationOnTypesTriFunction(IndexSchemaManager::validate, failureCollector, operationSubmitter);
    }

    @Override
    public void exportExpectedSchema(SearchSchemaCollector collector) {
        IndexSchemaCollectorDelegate collectorDelegate = new IndexSchemaCollectorDelegate(collector);
        for (PojoSchemaManagementIndexedTypeContext pojoSchemaManagementIndexedTypeContext : this.targetedTypeContexts) {
            IndexSchemaManager delegate = pojoSchemaManagementIndexedTypeContext.schemaManager();
            delegate.exportExpectedSchema((IndexSchemaCollector)collectorDelegate);
        }
    }

    @Override
    public void exportExpectedSchema(Path targetDirectory) {
        this.exportExpectedSchema(new FileSearchSchemaCollector(targetDirectory));
    }

    private CompletableFuture<?> doOperationOnTypesBiFunction(BiFunction<IndexSchemaManager, OperationSubmitter, CompletableFuture<?>> operation, FailureCollector failureCollector, OperationSubmitter operationSubmitter) {
        return this.doOperationOnTypesTriFunction((schemaManager, typeFailureCollector, submitter) -> (CompletableFuture)operation.apply((IndexSchemaManager)schemaManager, (OperationSubmitter)submitter), failureCollector, operationSubmitter);
    }

    private CompletableFuture<?> doOperationOnTypesTriFunction(TriFunction<IndexSchemaManager, ContextualFailureCollector, OperationSubmitter, CompletableFuture<?>> operation, FailureCollector failureCollector, OperationSubmitter operationSubmitter) {
        CompletableFuture[] futures = new CompletableFuture[this.targetedTypeContexts.size()];
        int typeCounter = 0;
        for (PojoSchemaManagementIndexedTypeContext pojoSchemaManagementIndexedTypeContext : this.targetedTypeContexts) {
            IndexSchemaManager delegate = pojoSchemaManagementIndexedTypeContext.schemaManager();
            ContextualFailureCollector typeFailureCollector = failureCollector.withContext(PojoEventContexts.fromType(pojoSchemaManagementIndexedTypeContext.typeIdentifier()));
            futures[typeCounter++] = ((CompletableFuture)operation.apply((Object)delegate, (Object)typeFailureCollector, (Object)operationSubmitter)).exceptionally(Futures.handler(e -> {
                typeFailureCollector.add((Throwable)Throwables.expectException((Throwable)e));
                return null;
            }));
        }
        return CompletableFuture.allOf(futures);
    }

    private static class IndexSchemaCollectorDelegate
    implements IndexSchemaCollector {
        private final SearchSchemaCollector delegate;

        private IndexSchemaCollectorDelegate(SearchSchemaCollector delegate) {
            this.delegate = delegate;
        }

        public void indexSchema(Optional<String> backendName, String indexName, SchemaExport export) {
            this.delegate.indexSchema(backendName, indexName, export);
        }
    }
}

